/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.spec.FactSpecMatcher;
import org.factcast.core.subscription.SubscriptionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgPostQueryMatcher
implements Predicate<Fact> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgPostQueryMatcher.class);
    private final boolean canBeSkipped;
    private final List<FactSpecMatcher> matchers = new LinkedList<FactSpecMatcher>();

    PgPostQueryMatcher(@NonNull SubscriptionRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        this.canBeSkipped = req.specs().stream().noneMatch(s -> s.jsFilterScript() != null);
        if (this.canBeSkipped) {
            log.trace("{} post query filtering has been disabled", (Object)req);
        } else {
            this.matchers.addAll(req.specs().stream().map(FactSpecMatcher::new).collect(Collectors.toList()));
        }
    }

    @Override
    public boolean test(Fact input) {
        return this.canBeSkipped || this.matchers.stream().anyMatch(m -> m.test(input));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean canBeSkipped() {
        return this.canBeSkipped;
    }
}

