/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import com.google.common.eventbus.EventBus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.factcast.core.Fact;
import org.factcast.core.subscription.Subscription;
import org.factcast.core.subscription.SubscriptionImpl;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.core.subscription.observer.FactObserver;
import org.factcast.core.subscription.observer.GenericObserver;
import org.factcast.store.pgsql.internal.PgFactStream;
import org.factcast.store.pgsql.internal.catchup.PgCatchupFactory;
import org.factcast.store.pgsql.internal.query.PgFactIdToSerialMapper;
import org.factcast.store.pgsql.internal.query.PgLatestSerialFetcher;
import org.springframework.jdbc.core.JdbcTemplate;

class PgSubscriptionFactory {
    private final JdbcTemplate jdbcTemplate;
    private final EventBus eventBus;
    private final PgFactIdToSerialMapper idToSerialMapper;
    private final PgLatestSerialFetcher fetcher;
    private final PgCatchupFactory catchupFactory;

    public Subscription subscribe(SubscriptionRequestTO req, FactObserver observer) {
        SubscriptionImpl subscription = SubscriptionImpl.on((GenericObserver)observer);
        PgFactStream pgsub = new PgFactStream(this.jdbcTemplate, this.eventBus, this.idToSerialMapper, (SubscriptionImpl<Fact>)subscription, this.fetcher, this.catchupFactory);
        CompletableFuture.runAsync(() -> pgsub.connect(req));
        return subscription.onClose(pgsub::close);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgSubscriptionFactory(JdbcTemplate jdbcTemplate, EventBus eventBus, PgFactIdToSerialMapper idToSerialMapper, PgLatestSerialFetcher fetcher, PgCatchupFactory catchupFactory) {
        this.jdbcTemplate = jdbcTemplate;
        this.eventBus = eventBus;
        this.idToSerialMapper = idToSerialMapper;
        this.fetcher = fetcher;
        this.catchupFactory = catchupFactory;
    }
}

