/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.store.pgsql.internal.query.PgLatestSerialFetcher;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

class PgSynchronizedQuery {
    @NonNull
    private final JdbcTemplate jdbcTemplate;
    @NonNull
    private final String sql;
    @NonNull
    private final PreparedStatementSetter setter;
    @NonNull
    private final RowCallbackHandler rowHandler;
    @NonNull
    private final TransactionTemplate transactionTemplate;
    @NonNull
    private final AtomicLong serialToContinueFrom;
    @NonNull
    private final PgLatestSerialFetcher latestFetcher;

    PgSynchronizedQuery(@NonNull JdbcTemplate jdbcTemplate, @NonNull String sql, @NonNull PreparedStatementSetter setter, @NonNull RowCallbackHandler rowHandler, AtomicLong serialToContinueFrom, PgLatestSerialFetcher fetcher) {
        if (jdbcTemplate == null) {
            throw new NullPointerException("jdbcTemplate is marked non-null but is null");
        }
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        if (rowHandler == null) {
            throw new NullPointerException("rowHandler is marked non-null but is null");
        }
        this.serialToContinueFrom = serialToContinueFrom;
        this.latestFetcher = fetcher;
        this.jdbcTemplate = jdbcTemplate;
        this.sql = sql;
        this.setter = setter;
        this.rowHandler = rowHandler;
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(jdbcTemplate.getDataSource());
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
    }

    public synchronized void run(boolean useIndex) {
        long latest = this.latestFetcher.retrieveLatestSer();
        this.transactionTemplate.execute(status -> {
            if (!useIndex) {
                this.jdbcTemplate.execute("SET LOCAL enable_bitmapscan=0;");
            }
            this.jdbcTemplate.query(this.sql, this.setter, this.rowHandler);
            return null;
        });
        this.serialToContinueFrom.set(Math.max(latest, this.serialToContinueFrom.get()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgSynchronizedQuery(@NonNull JdbcTemplate jdbcTemplate, @NonNull String sql, @NonNull PreparedStatementSetter setter, @NonNull RowCallbackHandler rowHandler, @NonNull TransactionTemplate transactionTemplate, @NonNull AtomicLong serialToContinueFrom, @NonNull PgLatestSerialFetcher latestFetcher) {
        if (jdbcTemplate == null) {
            throw new NullPointerException("jdbcTemplate is marked non-null but is null");
        }
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        if (rowHandler == null) {
            throw new NullPointerException("rowHandler is marked non-null but is null");
        }
        if (transactionTemplate == null) {
            throw new NullPointerException("transactionTemplate is marked non-null but is null");
        }
        if (serialToContinueFrom == null) {
            throw new NullPointerException("serialToContinueFrom is marked non-null but is null");
        }
        if (latestFetcher == null) {
            throw new NullPointerException("latestFetcher is marked non-null but is null");
        }
        this.jdbcTemplate = jdbcTemplate;
        this.sql = sql;
        this.setter = setter;
        this.rowHandler = rowHandler;
        this.transactionTemplate = transactionTemplate;
        this.serialToContinueFrom = serialToContinueFrom;
        this.latestFetcher = latestFetcher;
    }
}

