/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.store.StateToken;
import org.factcast.core.store.TokenStore;
import org.factcast.core.util.FactCastJson;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class PgTokenStore
implements TokenStore {
    private final JdbcTemplate tpl;

    @NonNull
    public StateToken create(@NonNull Map<UUID, Optional<UUID>> state, @NonNull Optional<String> nsOrNull) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (nsOrNull == null) {
            throw new NullPointerException("nsOrNull is marked non-null but is null");
        }
        String stateAsJson = FactCastJson.writeValueAsString((Object)StateJson.from(state));
        UUID queryForObject = (UUID)this.tpl.queryForObject("INSERT INTO tokenstore (ns,state) VALUES (?,cast (? as jsonb)) RETURNING token", new Object[]{nsOrNull.orElse(null), stateAsJson}, UUID.class);
        return new StateToken(queryForObject);
    }

    public void invalidate(@NonNull StateToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.tpl.update("DELETE FROM tokenstore WHERE token=?", new Object[]{token.uuid()});
    }

    @NonNull
    public Optional<Map<UUID, Optional<UUID>>> getState(@NonNull StateToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        try {
            String state = (String)this.tpl.queryForObject("SELECT state FROM tokenstore WHERE token=?", new Object[]{token.uuid()}, String.class);
            return Optional.of(((StateJson)FactCastJson.readValue(StateJson.class, (String)state)).toMap());
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public Optional<String> getNs(@NonNull StateToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        try {
            String ns = (String)this.tpl.queryForObject("SELECT ns FROM tokenstore WHERE token=?", new Object[]{token.uuid()}, String.class);
            return Optional.ofNullable(ns);
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgTokenStore(JdbcTemplate tpl) {
        this.tpl = tpl;
    }

    static class StateJson {
        private final Map<UUID, UUID> lastFactIdByAggregate = new LinkedHashMap<UUID, UUID>();

        StateJson() {
        }

        public static StateJson from(@NonNull Map<UUID, Optional<UUID>> state) {
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            StateJson json = new StateJson();
            state.forEach((key, value) -> {
                UUID cfr_ignored_0 = json.lastFactIdByAggregate.put((UUID)key, value.orElse(null));
            });
            return json;
        }

        public Map<UUID, Optional<UUID>> toMap() {
            HashMap<UUID, Optional<UUID>> ret = new HashMap<UUID, Optional<UUID>>();
            this.lastFactIdByAggregate.forEach((key, value) -> ret.put((UUID)key, Optional.ofNullable(value)));
            return ret;
        }
    }
}

