/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.catchup;

import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.store.pgsql.internal.PgConstants;
import org.factcast.store.pgsql.internal.rowmapper.PgFactExtractor;
import org.factcast.store.pgsql.internal.rowmapper.PgIdFactExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

public class PgCatchUpFetchPage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgCatchUpFetchPage.class);
    @NonNull
    private final JdbcTemplate jdbc;
    private final int pageSize;
    @NonNull
    private final SubscriptionRequestTO req;
    private final long clientId;

    public LinkedList<Fact> fetchFacts(@NonNull AtomicLong serial) {
        if (serial == null) {
            throw new NullPointerException("serial is marked non-null but is null");
        }
        Stopwatch sw = Stopwatch.createStarted();
        LinkedList<Fact> list = new LinkedList<Fact>(this.jdbc.query(PgConstants.SELECT_FACT_FROM_CATCHUP, this.createSetter(serial, this.pageSize), (RowMapper)new PgFactExtractor(serial)));
        sw.stop();
        log.debug("{}  fetched next page of Facts for cid={}, limit={}, ser>{} in {}ms", new Object[]{this.req, this.clientId, this.pageSize, serial.get(), sw.elapsed(TimeUnit.MILLISECONDS)});
        return list;
    }

    private PreparedStatementSetter createSetter(AtomicLong serial, int pageSize) {
        return ps -> {
            ps.setLong(1, this.clientId);
            ps.setLong(2, serial.get());
            ps.setLong(3, pageSize);
        };
    }

    public LinkedList<Fact> fetchIdFacts(@NonNull AtomicLong serial) {
        if (serial == null) {
            throw new NullPointerException("serial is marked non-null but is null");
        }
        Stopwatch sw = Stopwatch.createStarted();
        LinkedList<Fact> list = new LinkedList<Fact>(this.jdbc.query(PgConstants.SELECT_ID_FROM_CATCHUP, this.createSetter(serial, this.pageSize), (RowMapper)new PgIdFactExtractor(serial)));
        sw.stop();
        log.debug("{}  fetched next page of Ids for cid={}, limit={}, ser>{} in {}ms", new Object[]{this.req, this.clientId, this.pageSize, serial.get(), sw.elapsed(TimeUnit.MILLISECONDS)});
        return list;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgCatchUpFetchPage(@NonNull JdbcTemplate jdbc, int pageSize, @NonNull SubscriptionRequestTO req, long clientId) {
        if (jdbc == null) {
            throw new NullPointerException("jdbc is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        this.jdbc = jdbc;
        this.pageSize = pageSize;
        this.req = req;
        this.clientId = clientId;
    }
}

