/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.catchup;

import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.store.pgsql.internal.query.PgQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class PgCatchUpPrepare {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgCatchUpPrepare.class);
    private final JdbcTemplate jdbc;
    private final SubscriptionRequestTO req;

    public long prepareCatchup(AtomicLong serial) {
        PgQueryBuilder b = new PgQueryBuilder(this.req);
        long clientId = (Long)this.jdbc.queryForObject("SELECT nextval('catchup_seq')", Long.class);
        String catchupSQL = b.catchupSQL(clientId);
        return (Long)this.jdbc.execute(catchupSQL, ps -> {
            log.debug("{} preparing paging for matches after {}", (Object)this.req, (Object)serial.get());
            try {
                Stopwatch sw = Stopwatch.createStarted();
                b.createStatementSetter(serial).setValues(ps);
                int numberOfFactsToCatchup = ps.executeUpdate();
                sw.stop();
                if (numberOfFactsToCatchup > 0) {
                    log.debug("{} prepared {} facts for cid={} in {}ms", new Object[]{this.req, numberOfFactsToCatchup, clientId, sw.elapsed(TimeUnit.MILLISECONDS)});
                    return clientId;
                }
                log.debug("{} nothing to catch up", (Object)this.req);
                return 0L;
            }
            catch (SQLException ex) {
                log.error("While trying to prepare catchup", (Throwable)ex);
                throw ex;
            }
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgCatchUpPrepare(JdbcTemplate jdbc, SubscriptionRequestTO req) {
        this.jdbc = jdbc;
        this.req = req;
    }
}

