/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.catchup.paged;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.subscription.SubscriptionImpl;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.store.pgsql.PgConfigurationProperties;
import org.factcast.store.pgsql.internal.PgPostQueryMatcher;
import org.factcast.store.pgsql.internal.catchup.PgCatchUpFetchPage;
import org.factcast.store.pgsql.internal.catchup.PgCatchUpPrepare;
import org.factcast.store.pgsql.internal.catchup.PgCatchup;
import org.factcast.store.pgsql.internal.query.PgFactIdToSerialMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class PgPagedCatchup
implements PgCatchup {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgPagedCatchup.class);
    @NonNull
    private final JdbcTemplate jdbc;
    @NonNull
    private final PgConfigurationProperties props;
    @NonNull
    private final PgFactIdToSerialMapper serMapper;
    @NonNull
    private final SubscriptionRequestTO request;
    @NonNull
    private final PgPostQueryMatcher postQueryMatcher;
    @NonNull
    private final SubscriptionImpl<Fact> subscription;
    @NonNull
    private final AtomicLong serial;
    private long clientId = 0L;

    private LinkedList<Fact> doFetch(PgCatchUpFetchPage fetch) {
        if (this.idsOnly()) {
            return fetch.fetchIdFacts(this.serial);
        }
        return fetch.fetchFacts(this.serial);
    }

    private boolean idsOnly() {
        return this.request.idOnly() && this.postQueryMatcher.canBeSkipped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PgCatchUpPrepare prep = new PgCatchUpPrepare(this.jdbc, this.request);
        this.clientId = prep.prepareCatchup(this.serial);
        if (this.clientId > 0L) {
            try {
                LinkedList<Fact> facts;
                PgCatchUpFetchPage fetch = new PgCatchUpFetchPage(this.jdbc, this.idsOnly() ? this.props.getPageSizeForIds() : this.props.getPageSize(), this.request, this.clientId);
                while (!(facts = this.doFetch(fetch)).isEmpty()) {
                    while (!facts.isEmpty()) {
                        Fact f = facts.removeFirst();
                        UUID factId = f.id();
                        if (this.postQueryMatcher.test(f)) {
                            try {
                                this.subscription.notifyElement((Object)f);
                                log.trace("{} notifyElement called with id={}", (Object)this.request, (Object)factId);
                                continue;
                            }
                            catch (Throwable e) {
                                log.debug("{} exception from subscription: {}", (Object)this.request, (Object)e.getMessage());
                                try {
                                    this.subscription.close();
                                }
                                catch (Exception e1) {
                                    log.warn("{} exception while closing subscription: {}", (Object)this.request, (Object)e1.getMessage());
                                }
                                throw e;
                            }
                        }
                        log.trace("{} filtered id={}", (Object)this.request, (Object)factId);
                    }
                }
            }
            catch (Exception e) {
                try {
                    log.error("While fetching ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.jdbc.update("DELETE FROM catchup WHERE cid=?", new Object[]{this.clientId});
                    throw throwable;
                }
                this.jdbc.update("DELETE FROM catchup WHERE cid=?", new Object[]{this.clientId});
            }
            this.jdbc.update("DELETE FROM catchup WHERE cid=?", new Object[]{this.clientId});
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgPagedCatchup(@NonNull JdbcTemplate jdbc, @NonNull PgConfigurationProperties props, @NonNull PgFactIdToSerialMapper serMapper, @NonNull SubscriptionRequestTO request, @NonNull PgPostQueryMatcher postQueryMatcher, @NonNull SubscriptionImpl<Fact> subscription, @NonNull AtomicLong serial) {
        if (jdbc == null) {
            throw new NullPointerException("jdbc is marked non-null but is null");
        }
        if (props == null) {
            throw new NullPointerException("props is marked non-null but is null");
        }
        if (serMapper == null) {
            throw new NullPointerException("serMapper is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (postQueryMatcher == null) {
            throw new NullPointerException("postQueryMatcher is marked non-null but is null");
        }
        if (subscription == null) {
            throw new NullPointerException("subscription is marked non-null but is null");
        }
        if (serial == null) {
            throw new NullPointerException("serial is marked non-null but is null");
        }
        this.jdbc = jdbc;
        this.props = props;
        this.serMapper = serMapper;
        this.request = request;
        this.postQueryMatcher = postQueryMatcher;
        this.subscription = subscription;
        this.serial = serial;
    }
}

