/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.listen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.postgresql.jdbc.PgConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgConnectionSupplier {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgConnectionSupplier.class);
    @NonNull
    @VisibleForTesting
    protected final DataSource ds;

    public PgConnectionSupplier(javax.sql.DataSource dataSource) {
        if (!DataSource.class.isAssignableFrom(dataSource.getClass())) {
            throw new IllegalArgumentException("expected " + DataSource.class.getName() + " , but got " + dataSource.getClass().getName());
        }
        this.ds = (DataSource)dataSource;
    }

    public PgConnection get() throws SQLException {
        try {
            return (PgConnection)DriverManager.getDriver(this.ds.getUrl()).connect(this.ds.getUrl(), this.buildPgConnectionProperties(this.ds));
        }
        catch (SQLException e) {
            String msg = "Cannot acquire Connection from DriverManager: " + this.ds.getUrl();
            log.error(msg, (Throwable)e);
            throw e;
        }
    }

    private void setProperty(Properties dbp, String propertyName, String value) {
        if (value != null) {
            dbp.setProperty(propertyName, value);
        }
    }

    @VisibleForTesting
    Properties buildPgConnectionProperties(DataSource ds) {
        Properties dbp = new Properties();
        PoolConfiguration poolProperties = ds.getPoolProperties();
        if (poolProperties != null) {
            this.setProperty(dbp, "user", poolProperties.getUsername());
            this.setProperty(dbp, "password", poolProperties.getPassword());
            String connectionProperties = poolProperties.getConnectionProperties();
            if (connectionProperties != null) {
                try {
                    Map singleConnectionProperties = Splitter.on((String)";").omitEmptyStrings().withKeyValueSeparator("=").split((CharSequence)connectionProperties);
                    this.setProperty(dbp, "socketTimeout", (String)singleConnectionProperties.get("socketTimeout"));
                    this.setProperty(dbp, "connectTimeout", (String)singleConnectionProperties.get("connectTimeout"));
                    this.setProperty(dbp, "loginTimeout", (String)singleConnectionProperties.get("loginTimeout"));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("illegal connectionProperties: " + connectionProperties);
                }
            }
        }
        return dbp;
    }
}

