/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.listen;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.postgresql.PGNotification;
import org.postgresql.jdbc.PgConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgConnectionTester
implements Predicate<Connection> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgConnectionTester.class);
    private static int MAX_ALLOWED_NOTIFICATION_LATENCY_IN_MILLIS = 150;

    @Override
    public boolean test(@Nonnull Connection connection) {
        return this.testSelectStatement(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean testNotificationRoundTrip(Connection connection) {
        try {
            connection.prepareCall("LISTEN alive").execute();
            connection.prepareCall("NOTIFY alive").execute();
            PgConnection pc = (PgConnection)connection;
            PGNotification[] notifications = pc.getNotifications(MAX_ALLOWED_NOTIFICATION_LATENCY_IN_MILLIS);
            if (notifications == null || notifications.length == 0) {
                throw new SQLException("Missed notification from channel 'alive'");
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.warn("Connection test (Notification) failed with exception: {}", (Object)e.getMessage());
        }
        finally {
            try {
                connection.prepareCall("UNLISTEN alive").execute();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    boolean testSelectStatement(Connection connection) {
        try (PreparedStatement statement = this.prepareStatement(connection, "SELECT 42");
             ResultSet resultSet = statement.executeQuery();){
            resultSet.next();
            if (resultSet.getInt(1) == 42) {
                log.trace("Connection test passed (Select)");
                boolean bl = true;
                return bl;
            }
            log.warn("Connection test failed (Select)");
            return false;
        }
        catch (SQLException e) {
            log.warn("Connection test (Select) failed with exception: {}", (Object)e.getMessage());
        }
        return false;
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(string);
        statement.setQueryTimeout(1);
        return statement;
    }
}

