/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.listen;

import com.google.common.eventbus.EventBus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.store.pgsql.internal.listen.PgConnectionSupplier;
import org.postgresql.PGNotification;
import org.postgresql.jdbc.PgConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PgListener
implements InitializingBean,
DisposableBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgListener.class);
    @NonNull
    private final PgConnectionSupplier pgConnectionSupplier;
    @NonNull
    private final EventBus eventBus;
    @NonNull
    private final Predicate<Connection> pgConnectionTester;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private Thread listenerThread;
    private final int blockingWaitTimeInMillis = 60000;

    private void listen() {
        log.trace("Starting instance Listener");
        CountDownLatch l = new CountDownLatch(1);
        this.listenerThread = new Thread(() -> {
            while (this.running.get()) {
                this.postEvent("scheduled-poll");
                try {
                    PgConnection pc = this.pgConnectionSupplier.get();
                    Throwable throwable = null;
                    try {
                        while (this.running.get()) {
                            try (PreparedStatement ps = pc.prepareStatement("LISTEN fact_insert");){
                                log.trace("Running LISTEN command");
                                ps.execute();
                            }
                            if (this.pgConnectionTester.test((Connection)pc)) {
                                log.trace("Waiting for notifications for {}ms", (Object)60000);
                                l.countDown();
                                PGNotification[] notifications = pc.getNotifications(60000);
                                if (notifications != null && notifications.length > 0) {
                                    String name = notifications[0].getName();
                                    log.trace("notifying consumers for '{}'", (Object)name);
                                    this.postEvent(name);
                                    continue;
                                }
                                log.trace("No notifications yet. Looping.");
                                continue;
                            }
                            throw new SQLException("Connection is failing test");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pc == null) continue;
                        if (throwable != null) {
                            try {
                                pc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pc.close();
                    }
                }
                catch (SQLException e) {
                    log.warn("While waiting for Notifications", (Throwable)e);
                    this.sleep();
                }
            }
        }, "PG Instance Listener");
        this.listenerThread.setDaemon(true);
        this.listenerThread.setUncaughtExceptionHandler((t, e) -> log.error("thread " + t + " encountered an unhandled exception", e));
        this.listenerThread.start();
        try {
            l.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void postEvent(String name) {
        if (this.running.get()) {
            this.eventBus.post((Object)new FactInsertionEvent(name));
        }
    }

    public void afterPropertiesSet() {
        this.listen();
    }

    public void destroy() {
        this.running.set(false);
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgListener(@NonNull PgConnectionSupplier pgConnectionSupplier, @NonNull EventBus eventBus, @NonNull Predicate<Connection> pgConnectionTester) {
        if (pgConnectionSupplier == null) {
            throw new NullPointerException("pgConnectionSupplier is marked non-null but is null");
        }
        if (eventBus == null) {
            throw new NullPointerException("eventBus is marked non-null but is null");
        }
        if (pgConnectionTester == null) {
            throw new NullPointerException("pgConnectionTester is marked non-null but is null");
        }
        this.pgConnectionSupplier = pgConnectionSupplier;
        this.eventBus = eventBus;
        this.pgConnectionTester = pgConnectionTester;
    }

    public static class FactInsertionEvent {
        private final String name;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private FactInsertionEvent(String name) {
            this.name = name;
        }
    }
}

