/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.spec.FactSpec;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.store.pgsql.internal.PgConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;

public class PgQueryBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgQueryBuilder.class);
    private final boolean selectIdOnly;
    @NonNull
    private final SubscriptionRequestTO req;

    public PgQueryBuilder(@NonNull SubscriptionRequestTO request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.req = request;
        this.selectIdOnly = request.idOnly() && !request.hasAnyScriptFilters();
    }

    public PreparedStatementSetter createStatementSetter(@NonNull AtomicLong serial) {
        if (serial == null) {
            throw new NullPointerException("serial is marked non-null but is null");
        }
        return p -> {
            int count = 0;
            for (FactSpec spec : this.req.specs()) {
                UUID agg;
                p.setString(++count, "{\"ns\": \"" + spec.ns() + "\" }");
                String type = spec.type();
                if (type != null) {
                    p.setString(++count, "{\"type\": \"" + type + "\" }");
                }
                if ((agg = spec.aggId()) != null) {
                    p.setString(++count, "{\"aggIds\": [\"" + agg + "\"]}");
                }
                Map meta = spec.meta();
                for (Map.Entry e : meta.entrySet()) {
                    p.setString(++count, "{\"meta\":{\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\" }}");
                }
            }
            p.setLong(++count, serial.get());
        };
    }

    private String createWhereClause() {
        LinkedList predicates = new LinkedList();
        this.req.specs().forEach(spec -> {
            UUID agg;
            StringBuilder sb = new StringBuilder();
            sb.append("( ");
            sb.append("header").append(" @> ?::jsonb ");
            String type = spec.type();
            if (type != null) {
                sb.append("AND ").append("header").append(" @> ?::jsonb ");
            }
            if ((agg = spec.aggId()) != null) {
                sb.append("AND ").append("header").append(" @> ?::jsonb ");
            }
            Map meta = spec.meta();
            meta.forEach((key, value) -> sb.append("AND ").append("header").append(" @> ?::jsonb "));
            sb.append(") ");
            predicates.add(sb.toString());
        });
        String predicatesAsString = String.join((CharSequence)" OR ", predicates);
        return "( " + predicatesAsString + " ) AND " + "ser" + ">?";
    }

    public String createSQL() {
        String sql = "SELECT " + (this.selectIdOnly ? PgConstants.PROJECTION_ID : PgConstants.PROJECTION_FACT) + " FROM " + "fact" + " WHERE " + this.createWhereClause() + " ORDER BY " + "ser" + " ASC";
        log.trace("{} createSQL={}", (Object)this.req, (Object)sql);
        return sql;
    }

    public String catchupSQL(long clientId) {
        String sql = "INSERT INTO catchup (cid,ser) (SELECT " + clientId + "," + "ser" + " FROM " + "fact" + " WHERE (" + this.createWhereClause() + ") ORDER BY " + "ser" + " ASC)";
        log.trace("{} catchupSQL={}", (Object)this.req, (Object)sql);
        return sql;
    }
}

