/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal.rowmapper;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.IdOnlyFact;
import org.springframework.jdbc.core.RowMapper;

public class PgIdFactExtractor
implements RowMapper<Fact> {
    private final AtomicLong serial;

    @NonNull
    public Fact mapRow(@NonNull ResultSet rs, int rowNum) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs is marked non-null but is null");
        }
        this.serial.set(rs.getLong("ser"));
        return new IdOnlyFact(UUID.fromString(rs.getString("id")));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgIdFactExtractor(AtomicLong serial) {
        this.serial = serial;
    }
}

