/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.test.FactCastIntegrationTestExtension;
import org.factcast.test.toxi.FactCastProxy;
import org.factcast.test.toxi.PostgresqlProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.utility.DockerImageName;

public class FactCastIntegrationTestExecutionListener
implements TestExecutionListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FactCastIntegrationTestExecutionListener.class);
    public static final Network _docker_network = Network.newNetwork();
    public static final String TOXIPROXY_NETWORK_ALIAS = "toxiproxy";
    private static List<FactCastIntegrationTestExtension> extensions = new LinkedList<FactCastIntegrationTestExtension>();
    private static List<FactCastIntegrationTestExtension> reverseExtensions;
    private static ToxiproxyContainer toxiProxy;
    private static ToxiproxyClient toxiClient;
    private static AtomicBoolean initialized;

    public void beforeTestClass(@NonNull TestContext testContext) throws Exception {
        Objects.requireNonNull(testContext, "testContext is marked non-null but is null");
        if (!initialized.getAndSet(true)) {
            FactCastIntegrationTestExecutionListener.initialize();
        }
        for (FactCastIntegrationTestExtension e : extensions) {
            e.prepareContainers(testContext);
        }
        for (FactCastIntegrationTestExtension e : extensions) {
            e.beforeAll(testContext);
        }
    }

    public void beforeTestMethod(@NonNull TestContext testContext) throws Exception {
        Objects.requireNonNull(testContext, "testContext is marked non-null but is null");
        toxiClient.reset();
        for (FactCastIntegrationTestExtension e : extensions) {
            e.wipeExternalDataStore(testContext);
        }
        for (FactCastIntegrationTestExtension e : extensions) {
            e.injectFields(testContext);
        }
        for (FactCastIntegrationTestExtension e : extensions) {
            e.beforeEach(testContext);
        }
    }

    public void afterTestMethod(@NonNull TestContext testContext) throws SQLException {
        Objects.requireNonNull(testContext, "testContext is marked non-null but is null");
        for (FactCastIntegrationTestExtension e : reverseExtensions) {
            e.afterEach(testContext);
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        testContext.markApplicationContextDirty(DirtiesContext.HierarchyMode.EXHAUSTIVE);
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
        for (FactCastIntegrationTestExtension e : reverseExtensions) {
            e.afterAll(testContext);
        }
    }

    public void afterTestExecution(TestContext testContext) throws Exception {
        toxiClient.reset();
        for (FactCastIntegrationTestExtension e : extensions) {
            e.wipeExternalDataStore(testContext);
        }
    }

    private static void initialize() {
        FactCastIntegrationTestExecutionListener.initializeProxy();
        ArrayList discovered = Lists.newArrayList(ServiceLoader.load(FactCastIntegrationTestExtension.class).iterator());
        AtomicInteger count = new AtomicInteger(discovered.size());
        while (!discovered.isEmpty()) {
            for (FactCastIntegrationTestExtension e : discovered) {
                if (!e.initialize()) continue;
                extensions.add(e);
            }
            discovered.removeAll(extensions);
            if (discovered.size() != count.getAndSet(discovered.size())) continue;
            throw new IllegalStateException("Failed to initialize extensions:\n" + discovered.stream().map(f -> " " + f.getClass() + ": " + f.createUnableToInitializeMessage()).collect(Collectors.joining(",\n")));
        }
        reverseExtensions = Lists.newArrayList(extensions);
        Collections.reverse(reverseExtensions);
    }

    private static void initializeProxy() {
        toxiProxy = (ToxiproxyContainer)((ToxiproxyContainer)new ToxiproxyContainer(DockerImageName.parse((String)"ghcr.io/shopify/toxiproxy:2.5.0").asCompatibleSubstituteFor("shopify/toxiproxy")).withNetwork(_docker_network)).withNetworkAliases(new String[]{TOXIPROXY_NETWORK_ALIAS});
        toxiProxy.start();
        String host = toxiProxy.getHost();
        int controlPort = toxiProxy.getControlPort();
        toxiClient = new ToxiproxyClient(host, controlPort);
    }

    public static ToxiproxyContainer.ContainerProxy createProxy(GenericContainer<?> container, int port) {
        return toxiProxy.getProxy(container, port);
    }

    public static ToxiproxyClient client() {
        return toxiClient;
    }

    static {
        initialized = new AtomicBoolean(false);
    }

    static final class Containers {
        private final PostgreSQLContainer<?> db;
        private final GenericContainer<?> fc;
        private final PostgresqlProxy pgProxy;
        private final FactCastProxy fcProxy;
        private final String jdbcUrl;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Containers(PostgreSQLContainer<?> db, GenericContainer<?> fc, PostgresqlProxy pgProxy, FactCastProxy fcProxy, String jdbcUrl) {
            this.db = db;
            this.fc = fc;
            this.pgProxy = pgProxy;
            this.fcProxy = fcProxy;
            this.jdbcUrl = jdbcUrl;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PostgreSQLContainer<?> db() {
            return this.db;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericContainer<?> fc() {
            return this.fc;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PostgresqlProxy pgProxy() {
            return this.pgProxy;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FactCastProxy fcProxy() {
            return this.fcProxy;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String jdbcUrl() {
            return this.jdbcUrl;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Containers)) {
                return false;
            }
            Containers other = (Containers)o;
            PostgreSQLContainer<?> this$db = this.db();
            PostgreSQLContainer<?> other$db = other.db();
            if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
                return false;
            }
            GenericContainer<?> this$fc = this.fc();
            GenericContainer<?> other$fc = other.fc();
            if (this$fc == null ? other$fc != null : !this$fc.equals(other$fc)) {
                return false;
            }
            PostgresqlProxy this$pgProxy = this.pgProxy();
            PostgresqlProxy other$pgProxy = other.pgProxy();
            if (this$pgProxy == null ? other$pgProxy != null : !this$pgProxy.equals(other$pgProxy)) {
                return false;
            }
            FactCastProxy this$fcProxy = this.fcProxy();
            FactCastProxy other$fcProxy = other.fcProxy();
            if (this$fcProxy == null ? other$fcProxy != null : !this$fcProxy.equals(other$fcProxy)) {
                return false;
            }
            String this$jdbcUrl = this.jdbcUrl();
            String other$jdbcUrl = other.jdbcUrl();
            return !(this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PostgreSQLContainer<?> $db = this.db();
            result = result * 59 + ($db == null ? 43 : $db.hashCode());
            GenericContainer<?> $fc = this.fc();
            result = result * 59 + ($fc == null ? 43 : $fc.hashCode());
            PostgresqlProxy $pgProxy = this.pgProxy();
            result = result * 59 + ($pgProxy == null ? 43 : $pgProxy.hashCode());
            FactCastProxy $fcProxy = this.fcProxy();
            result = result * 59 + ($fcProxy == null ? 43 : $fcProxy.hashCode());
            String $jdbcUrl = this.jdbcUrl();
            result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "FactCastIntegrationTestExecutionListener.Containers(db=" + this.db() + ", fc=" + this.fc() + ", pgProxy=" + this.pgProxy() + ", fcProxy=" + this.fcProxy() + ", jdbcUrl=" + this.jdbcUrl() + ")";
        }
    }
}

