/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.util.MavenHelper;
import org.factcast.test.FactcastVersion;
import org.factcast.test.PostgresVersion;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Inherited
public @interface FactcastTestConfig {
    public String factcastVersion() default "";

    public String postgresVersion() default "";

    public String configDir() default "./config";

    public boolean securityEnabled() default false;

    public static final class Config {
        private final String factcastVersion;
        private final String postgresVersion;
        private final String configDir;
        private final boolean securityEnabled;
        static final String CONFIG_DIR = "./config";

        static Config defaults() {
            return new Config(FactcastVersion.get(), PostgresVersion.get(), CONFIG_DIR, false);
        }

        public String factcastVersion() {
            return Config.resolve(this.factcastVersion);
        }

        static Config from(@NonNull FactcastTestConfig e) {
            Objects.requireNonNull(e, "e is marked non-null but is null");
            Config config = Config.defaults().withConfigDir(e.configDir()).withSecurityEnabled(e.securityEnabled());
            if (!e.factcastVersion().isEmpty()) {
                config = config.withFactcastVersion(e.factcastVersion());
            }
            if (!e.postgresVersion().isEmpty()) {
                config = config.withPostgresVersion(e.postgresVersion());
            }
            return config;
        }

        private static String resolve(@NonNull String versionAsAnnotated) {
            Objects.requireNonNull(versionAsAnnotated, "versionAsAnnotated is marked non-null but is null");
            if (versionAsAnnotated.isEmpty()) {
                if (Config.runFromJar()) {
                    return Config.jarVersion();
                }
                return "latest";
            }
            return versionAsAnnotated;
        }

        private static String jarVersion() {
            return (String)MavenHelper.getVersion((String)"factcast-test", FactcastTestConfig.class).orElseThrow(() -> new IllegalStateException("Cannot retrieve current version."));
        }

        private static boolean runFromJar() {
            return Objects.requireNonNull(FactcastTestConfig.class.getResource("/" + FactcastTestConfig.class.getName().replace(".", "/") + ".class")).toString().startsWith("jar:");
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Config(String factcastVersion, String postgresVersion, String configDir, boolean securityEnabled) {
            this.factcastVersion = factcastVersion;
            this.postgresVersion = postgresVersion;
            this.configDir = configDir;
            this.securityEnabled = securityEnabled;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String postgresVersion() {
            return this.postgresVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String configDir() {
            return this.configDir;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean securityEnabled() {
            return this.securityEnabled;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (this.securityEnabled() != other.securityEnabled()) {
                return false;
            }
            String this$factcastVersion = this.factcastVersion();
            String other$factcastVersion = other.factcastVersion();
            if (this$factcastVersion == null ? other$factcastVersion != null : !this$factcastVersion.equals(other$factcastVersion)) {
                return false;
            }
            String this$postgresVersion = this.postgresVersion();
            String other$postgresVersion = other.postgresVersion();
            if (this$postgresVersion == null ? other$postgresVersion != null : !this$postgresVersion.equals(other$postgresVersion)) {
                return false;
            }
            String this$configDir = this.configDir();
            String other$configDir = other.configDir();
            return !(this$configDir == null ? other$configDir != null : !this$configDir.equals(other$configDir));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.securityEnabled() ? 79 : 97);
            String $factcastVersion = this.factcastVersion();
            result = result * 59 + ($factcastVersion == null ? 43 : $factcastVersion.hashCode());
            String $postgresVersion = this.postgresVersion();
            result = result * 59 + ($postgresVersion == null ? 43 : $postgresVersion.hashCode());
            String $configDir = this.configDir();
            result = result * 59 + ($configDir == null ? 43 : $configDir.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "FactcastTestConfig.Config(factcastVersion=" + this.factcastVersion() + ", postgresVersion=" + this.postgresVersion() + ", configDir=" + this.configDir() + ", securityEnabled=" + this.securityEnabled() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Config withFactcastVersion(String factcastVersion) {
            return this.factcastVersion == factcastVersion ? this : new Config(factcastVersion, this.postgresVersion, this.configDir, this.securityEnabled);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Config withPostgresVersion(String postgresVersion) {
            return this.postgresVersion == postgresVersion ? this : new Config(this.factcastVersion, postgresVersion, this.configDir, this.securityEnabled);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Config withConfigDir(String configDir) {
            return this.configDir == configDir ? this : new Config(this.factcastVersion, this.postgresVersion, configDir, this.securityEnabled);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Config withSecurityEnabled(boolean securityEnabled) {
            return this.securityEnabled == securityEnabled ? this : new Config(this.factcastVersion, this.postgresVersion, this.configDir, securityEnabled);
        }
    }
}

