/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.HashSet;
import java.util.Set;
import org.fakereplace.AgentOption;
import org.fakereplace.AgentOptions;
import org.fakereplace.IntegrationLoader;
import org.fakereplace.Transformer;
import org.fakereplace.api.ClassChangeNotifier;
import org.fakereplace.api.Extension;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.classloading.ClassLookupManager;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.replacement.AddedClass;
import org.fakereplace.replacement.ClassRedefiner;
import org.fakereplace.replacement.ReplacementResult;
import org.fakereplace.server.FakereplaceServer;
import org.fakereplace.transformation.ClassLoaderTransformer;
import org.fakereplace.transformation.MainTransformer;
import org.fakereplace.transformation.UnmodifiedFileIndex;

public class Agent {
    private static final Class[] EMPTY_CL_ARRAY = new Class[0];
    private static volatile Instrumentation inst;
    private static volatile MainTransformer mainTransformer;
    public static final String DUMP_CLASSES = "dump-classes";

    public static void premain(String s, Instrumentation i) {
        MainTransformer mainTransformer;
        AgentOptions.setup(s);
        inst = i;
        Set<Extension> extension = IntegrationLoader.getIntegrationInfo(ClassLoader.getSystemClassLoader());
        for (Extension info : extension) {
        }
        UnmodifiedFileIndex.loadIndex();
        HashSet<Class> cls = new HashSet<Class>();
        for (Class c : inst.getAllLoadedClasses()) {
            if (!ClassLoader.class.isAssignableFrom(c)) continue;
            cls.add(c);
        }
        ClassLoaderTransformer classLoaderTransformer = new ClassLoaderTransformer();
        Agent.mainTransformer = mainTransformer = new MainTransformer(extension);
        inst.addTransformer(mainTransformer, true);
        mainTransformer.addTransformer(classLoaderTransformer);
        try {
            inst.retransformClasses(cls.toArray(EMPTY_CL_ARRAY));
        }
        catch (UnmodifiableClassException e) {
            e.printStackTrace();
        }
        mainTransformer.addTransformer(new Transformer(extension));
        Thread thread = new Thread(new FakereplaceServer(6555));
        thread.setDaemon(true);
        thread.setName("Fakereplace Thread");
        thread.start();
    }

    public static void redefine(ClassDefinition[] classes, AddedClass[] addedData) throws UnmodifiableClassException, ClassNotFoundException {
        ClassIdentifier[] addedClass = new ClassIdentifier[addedData.length];
        int count = 0;
        for (AddedClass i : addedData) {
            addedClass[count++] = i.getClassIdentifier();
        }
        Class[] changedClasses = new Class[classes.length];
        count = 0;
        for (ClassDefinition i : classes) {
            System.out.println("Fakereplace is replacing class " + i.getDefinitionClass());
            changedClasses[count++] = i.getDefinitionClass();
            ClassDataStore.instance().markClassReplaced(i.getClass());
        }
        ClassChangeNotifier.instance().beforeChange(changedClasses, addedClass);
        ReplacementResult result = ClassRedefiner.rewriteLoadedClasses(classes);
        try {
            for (AddedClass c : addedData) {
                ClassLookupManager.addClassInfo(c.getClassName(), c.getLoader(), c.getData());
            }
            inst.redefineClasses(result.getClasses());
            if (!result.getClassesToRetransform().isEmpty()) {
                inst.retransformClasses(result.getClassesToRetransform().toArray(new Class[result.getClassesToRetransform().size()]));
            }
            Introspector.flushCaches();
            ClassChangeNotifier.instance().notify(changedClasses, addedClass);
        }
        catch (Throwable e) {
            try {
                for (ClassDefinition d : classes) {
                    try {
                        ByteArrayInputStream bin = new ByteArrayInputStream(d.getDefinitionClassFile());
                        DataInputStream dis = new DataInputStream(bin);
                        ClassFile file = new ClassFile(dis);
                        Transformer.getManipulator().transformClass(file, d.getDefinitionClass().getClassLoader(), true);
                        String dumpDir = AgentOptions.getOption(AgentOption.DUMP_DIR);
                        if (dumpDir == null) continue;
                        FileOutputStream s = new FileOutputStream(dumpDir + '/' + d.getDefinitionClass().getName() + "1.class");
                        DataOutputStream dos = new DataOutputStream(s);
                        file.write(dos);
                        dos.flush();
                        dos.close();
                        s.close();
                    }
                    catch (IOException a) {
                        a.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    public static Instrumentation getInstrumentation() {
        return inst;
    }
}

