/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace;

import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentMap;
import org.fakereplace.Agent;
import org.fakereplace.classloading.ClassLookupManager;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.javassist.bytecode.BadBytecode;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.util.JumpMarker;
import org.fakereplace.util.JumpUtils;

public class ClassLoaderInstrumentation {
    private static final ConcurrentMap<Class, Object> instrumentedLoaders = new MapMaker().weakKeys().makeMap();

    public static synchronized void instrumentClassLoaderIfRequired(Class<?> classLoader) {
        if (ClassLoader.class.isAssignableFrom(classLoader) && !instrumentedLoaders.containsKey(classLoader)) {
            try {
                Agent.getInstrumentation().retransformClasses(classLoader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            instrumentedLoaders.put(classLoader, ClassLoaderInstrumentation.class);
        }
    }

    public static boolean redefineClassLoader(ClassFile classFile) throws BadBytecode {
        boolean modified = false;
        for (MethodInfo method : classFile.getMethods()) {
            if (Modifier.isStatic(method.getAccessFlags()) || !method.getName().equals("loadClass") || !method.getDescriptor().equals("(Ljava/lang/String;)Ljava/lang/Class;") && !method.getDescriptor().equals("(Ljava/lang/String;Z)Ljava/lang/Class;")) continue;
            modified = true;
            if (method.getCodeAttribute().getMaxLocals() < 4) {
                method.getCodeAttribute().setMaxLocals(4);
            }
            CodeIterator iterator = method.getCodeAttribute().iterator();
            Bytecode b = new Bytecode(classFile.getConstPool());
            b.addAload(1);
            b.addAload(0);
            b.addInvokestatic(ClassLookupManager.class.getName(), "getClassData", "(Ljava/lang/String;Ljava/lang/Object;)[B");
            b.add(89);
            b.add(198);
            JumpMarker jumpEnd = JumpUtils.addJumpInstruction(b);
            b.addAload(0);
            b.addAload(1);
            b.addInvokevirtual("java.lang.ClassLoader", "findLoadedClass", "(Ljava/lang/String;)Ljava/lang/Class;");
            b.add(89);
            b.add(198);
            JumpMarker notFound = JumpUtils.addJumpInstruction(b);
            b.add(176);
            notFound.mark();
            b.add(87);
            b.addAstore(3);
            b.addAload(0);
            b.addAload(1);
            b.addAload(3);
            b.addIconst(0);
            b.addAload(3);
            b.add(190);
            b.addInvokevirtual("java.lang.ClassLoader", "defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            if (method.getDescriptor().equals("Ljava/lang/String;Z)Ljava/lang/Class;")) {
                b.addIload(2);
            } else {
                b.addIconst(0);
            }
            b.add(153);
            JumpMarker linkJumpEnd = JumpUtils.addJumpInstruction(b);
            b.add(89);
            b.addAload(0);
            b.add(95);
            b.addInvokevirtual("java.lang.ClassLoader", "resolveClass", "(Ljava/lang/Class;)V");
            linkJumpEnd.mark();
            b.add(176);
            jumpEnd.mark();
            b.add(87);
            if (!(classFile.getName().startsWith("java.") || classFile.getName().startsWith("com.sun") || classFile.getName().startsWith("sun"))) {
                b.addAload(1);
                b.addLdc("org.fakereplace");
                b.addInvokevirtual(String.class.getName(), "startsWith", "(Ljava/lang/String;)Z");
                b.add(153);
                JumpMarker notFakereplace = JumpUtils.addJumpInstruction(b);
                b.addInvokestatic(ClassLoader.class.getName(), "getSystemClassLoader", "()Ljava/lang/ClassLoader;");
                b.addAload(1);
                b.addInvokevirtual(ClassLoader.class.getName(), "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;");
                b.add(176);
                notFakereplace.mark();
            }
            iterator.insert(b.get());
            method.getCodeAttribute().computeMaxStack();
        }
        return modified;
    }

    private ClassLoaderInstrumentation() {
    }
}

