/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.fakereplace.api.Extension;
import org.fakereplace.logging.Logger;

public class IntegrationLoader {
    public static final String INTEGRATION_PACKAGE = "org/fakereplace/integration";
    public static final String EXTENSION = "Extension";
    private static final Logger log = Logger.getLogger(IntegrationLoader.class);

    public static Set<Extension> getIntegrationInfo(ClassLoader clr) {
        HashSet<Extension> integrations = new HashSet<Extension>();
        HashSet<String> intPackages = new HashSet<String>();
        try {
            Enumeration<URL> urlJars = clr.getResources(INTEGRATION_PACKAGE);
            while (urlJars.hasMoreElements()) {
                URL urlJar = urlJars.nextElement();
                if (urlJar == null) continue;
                try {
                    URLConnection urlConnection = urlJar.openConnection();
                    if (!(urlConnection instanceof JarURLConnection)) continue;
                    JarURLConnection conn = (JarURLConnection)urlJar.openConnection();
                    JarFile file = conn.getJarFile();
                    Enumeration<JarEntry> it = file.entries();
                    while (it.hasMoreElements()) {
                        String end;
                        JarEntry entry = it.nextElement();
                        if (!entry.getName().contains(INTEGRATION_PACKAGE) || (end = entry.getName().substring(INTEGRATION_PACKAGE.length() + 1)).length() <= 0) continue;
                        String subPack = end.substring(0, end.indexOf(47));
                        intPackages.add(subPack);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String s : intPackages) {
                Extension info = IntegrationLoader.loadIntegration(s);
                if (info == null) continue;
                integrations.add(info);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return integrations;
    }

    private static Extension loadIntegration(String name) {
        String integrationClass = "org.fakereplace.integration." + name + "." + name.substring(0, 1).toUpperCase() + name.substring(1) + EXTENSION;
        try {
            Class<?> cls = Class.forName(integrationClass);
            Extension info = (Extension)cls.newInstance();
            return info;
        }
        catch (Exception e) {
            log.error("Could not load integration for " + name + ": " + integrationClass, e);
            return null;
        }
    }
}

