/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.com.google.common.base;

import java.io.Serializable;
import org.fakereplace.com.google.common.annotations.VisibleForTesting;
import org.fakereplace.com.google.common.base.Function;
import org.fakereplace.com.google.common.base.Preconditions;
import org.fakereplace.com.google.common.base.Supplier;

public final class Suppliers {
    private Suppliers() {
    }

    public static <F, T> Supplier<T> compose(Function<? super F, T> function, Supplier<F> first) {
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(first);
        return new SupplierComposition<F, T>(function, first);
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return new MemoizingSupplier<T>(Preconditions.checkNotNull(delegate));
    }

    public static <T> Supplier<T> ofInstance(T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    public static <T> Supplier<T> synchronizedSupplier(Supplier<T> delegate) {
        return new ThreadSafeSupplier<T>(Preconditions.checkNotNull(delegate));
    }

    private static class ThreadSafeSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        private static final long serialVersionUID = 0L;

        ThreadSafeSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Supplier<T> supplier = this.delegate;
            synchronized (supplier) {
                return this.delegate.get();
            }
        }
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        final T instance;
        private static final long serialVersionUID = 0L;

        SupplierOfInstance(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }

    @VisibleForTesting
    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        transient boolean initialized;
        transient T value;
        private static final long serialVersionUID = 0L;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized T get() {
            if (!this.initialized) {
                this.value = this.delegate.get();
                this.initialized = true;
            }
            return this.value;
        }
    }

    private static class SupplierComposition<F, T>
    implements Supplier<T>,
    Serializable {
        final Function<? super F, ? extends T> function;
        final Supplier<? extends F> first;
        private static final long serialVersionUID = 0L;

        SupplierComposition(Function<? super F, ? extends T> function, Supplier<? extends F> first) {
            this.function = function;
            this.first = first;
        }

        @Override
        public T get() {
            return this.function.apply(this.first.get());
        }
    }
}

