/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.util.HashSet;
import java.util.Set;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassData;
import org.fakereplace.data.FieldData;
import org.fakereplace.data.MemberType;
import org.fakereplace.data.MethodData;
import org.fakereplace.javassist.bytecode.FieldInfo;

public class ClassDataBuilder {
    private final BaseClassData baseData;
    private final Set<FieldData> fakeFields = new HashSet<FieldData>();
    private final Set<MethodData> fakeMethods = new HashSet<MethodData>();
    private final Set<MethodData> removedMethods = new HashSet<MethodData>();
    private final Set<FieldData> removedFields = new HashSet<FieldData>();

    public ClassDataBuilder(BaseClassData b) {
        if (b == null) {
            throw new RuntimeException("Attempted to created ClassDataBuilder with null BaseClassData");
        }
        this.baseData = b;
    }

    public ClassData buildClassData() {
        return new ClassData(this.baseData, this.fakeMethods, this.removedMethods, this.fakeFields, this.removedFields);
    }

    public BaseClassData getBaseData() {
        return this.baseData;
    }

    public FieldData addFakeField(FieldInfo newField, String proxyName, int modifiers) {
        FieldData data = new FieldData(newField, MemberType.FAKE, proxyName, modifiers);
        this.fakeFields.add(data);
        return data;
    }

    public MethodData addFakeMethod(String name, String descriptor, String proxyName, int accessFlags) {
        MethodData data = new MethodData(name, descriptor, proxyName, MemberType.FAKE, accessFlags, false);
        this.fakeMethods.add(data);
        return data;
    }

    public MethodData addFakeConstructor(String name, String descriptor, String proxyName, int accessFlags, int methodCount) {
        MethodData data = new MethodData(name, descriptor, proxyName, MemberType.FAKE_CONSTRUCTOR, accessFlags, methodCount);
        this.fakeMethods.add(data);
        return data;
    }

    public void removeRethod(MethodData md) {
        MethodData nmd = new MethodData(md.getMethodName(), md.getDescriptor(), md.getClassName(), MemberType.REMOVED, md.getAccessFlags(), false);
        this.removedMethods.add(nmd);
    }

    public void removeField(FieldData md) {
        FieldData nd = new FieldData(md, MemberType.REMOVED);
        this.removedFields.add(nd);
    }
}

