/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.fakereplace.BuiltinClassData;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassData;
import org.fakereplace.data.ClassDataBuilder;
import org.fakereplace.data.MethodData;
import org.fakereplace.manip.util.MapFunction;
import org.fakereplace.reflection.FieldAccessor;

public class ClassDataStore {
    private static final ClassDataStore INSTANCE = new ClassDataStore();
    private final Map<String, Class<?>> proxyNameToReplacedClass = new ConcurrentHashMap();
    private final Map<String, FieldAccessor> proxyNameToFieldAccessor = new ConcurrentHashMap<String, FieldAccessor>();
    private final Map<ClassLoader, ConcurrentMap<String, ClassData>> classData = new MapMaker().weakKeys().makeComputingMap(new MapFunction(false));
    private final Map<ClassLoader, ConcurrentMap<String, BaseClassData>> baseClassData = new MapMaker().weakKeys().makeComputingMap(new MapFunction(false));
    private final Map<String, MethodData> proxyNameToMethodData = new ConcurrentHashMap<String, MethodData>();
    private final Set<Class<?>> replacedClasses = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private static final ClassLoader NULL_LOADER = new ClassLoader(){};

    private ClassDataStore() {
    }

    public void markClassReplaced(Class<?> clazz) {
        this.replacedClasses.add(clazz);
    }

    public boolean isClassReplaced(Class<?> clazz) {
        return this.replacedClasses.contains(clazz);
    }

    public void saveClassData(ClassLoader loader, String className, ClassDataBuilder data) {
        className = className.replace('/', '.');
        if (loader == null) {
            loader = NULL_LOADER;
        }
        Map map = this.classData.get(loader);
        map.put(className, data.buildClassData());
    }

    public void saveClassData(ClassLoader loader, String className, BaseClassData data) {
        className = className.replace('/', '.');
        if (loader == null) {
            loader = NULL_LOADER;
        }
        Map map = this.baseClassData.get(loader);
        map.put(className, data);
    }

    public ClassData getModifiedClassData(ClassLoader loader, String className) {
        Map map;
        ClassData cd;
        className = className.replace('/', '.');
        if (loader == null) {
            loader = NULL_LOADER;
        }
        if ((cd = (ClassData)(map = (Map)this.classData.get(loader)).get(className)) == null) {
            BaseClassData dd = this.getBaseClassData(loader, className);
            if (dd == null) {
                return null;
            }
            ClassDataBuilder builder = new ClassDataBuilder(dd);
            ClassData d = builder.buildClassData();
            map.put(className, d);
            return d;
        }
        return cd;
    }

    public BaseClassData getBaseClassData(ClassLoader loader, String className) {
        Map map;
        className = className.replace('/', '.');
        if (loader == null) {
            loader = NULL_LOADER;
        }
        if (!(map = (Map)this.baseClassData.get(loader)).containsKey(className)) {
            if (BuiltinClassData.skipInstrumentation(className)) {
                try {
                    Class<?> cls;
                    if (loader != NULL_LOADER) {
                        cls = loader.loadClass(className);
                        this.saveClassData(loader, className, new BaseClassData(cls));
                    }
                    cls = Class.forName(className);
                    this.saveClassData(loader, className, new BaseClassData(cls));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            } else {
                return null;
            }
        }
        BaseClassData cd = (BaseClassData)map.get(className);
        return cd;
    }

    public Class<?> getRealClassFromProxyName(String proxyName) {
        return this.proxyNameToReplacedClass.get(proxyName);
    }

    public void registerProxyName(Class<?> c, String proxyName) {
        this.proxyNameToReplacedClass.put(proxyName, c);
    }

    public void registerFieldAccessor(String proxyName, FieldAccessor accessor) {
        this.proxyNameToFieldAccessor.put(proxyName, accessor);
    }

    public void registerReplacedMethod(String proxyName, MethodData methodData) {
        this.proxyNameToMethodData.put(proxyName, methodData);
    }

    public MethodData getMethodInformation(String proxyName) {
        return this.proxyNameToMethodData.get(proxyName);
    }

    public FieldAccessor getFieldAccessor(String proxyName) {
        return this.proxyNameToFieldAccessor.get(proxyName);
    }

    public static ClassDataStore instance() {
        return INSTANCE;
    }
}

