/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.HashSet;
import java.util.List;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.util.JumpMarker;
import org.fakereplace.util.JumpUtils;

public class MethodAccessManipulator
implements ClassManipulator {
    public static final String METHOD_NAME = "invoke";
    public static final String REPLACED_METHOD_DESCRIPTOR = "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    public static final String METHOD_DESCRIPTOR = "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final Logger log = Logger.getLogger(MethodAccessManipulator.class);

    @Override
    public void clearRewrites(String className, ClassLoader loader) {
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        HashSet<Integer> methodCallLocations = new HashSet<Integer>();
        Integer newCallLocation = null;
        Integer methodReflectionLocation = null;
        ConstPool pool = file.getConstPool();
        for (int i = 1; i < pool.getSize(); ++i) {
            if (pool.getTag(i) != 10) continue;
            String className = pool.getMethodrefClassName(i);
            String methodName = pool.getMethodrefName(i);
            if (!className.equals("java.lang.reflect.Method") || !methodName.equals(METHOD_NAME)) continue;
            methodCallLocations.add(i);
            if (newCallLocation != null) continue;
            methodReflectionLocation = pool.addClassInfo("org.fakereplace.reflection.MethodReflection");
            newCallLocation = pool.addNameAndTypeInfo(METHOD_NAME, REPLACED_METHOD_DESCRIPTOR);
        }
        if (newCallLocation != null) {
            List methods = file.getMethods();
            for (MethodInfo m : methods) {
                try {
                    if (m.getCodeAttribute() == null) continue;
                    CodeIterator it = m.getCodeAttribute().iterator();
                    while (it.hasNext()) {
                        int val;
                        int index = it.next();
                        int op = it.byteAt(index);
                        if (op != 182 || !methodCallLocations.contains(val = it.s16bitAt(index + 1))) continue;
                        Bytecode b = new Bytecode(file.getConstPool());
                        b.add(91);
                        b.add(87);
                        b.add(91);
                        b.add(87);
                        b.add(91);
                        b.addInvokestatic(methodReflectionLocation, "fakeCallRequired", "(Ljava/lang/reflect/Method;)Z");
                        b.add(153);
                        JumpMarker performRealCall = JumpUtils.addJumpInstruction(b);
                        b.addInvokestatic(methodReflectionLocation, METHOD_NAME, REPLACED_METHOD_DESCRIPTOR);
                        b.add(167);
                        JumpMarker finish = JumpUtils.addJumpInstruction(b);
                        performRealCall.mark();
                        b.addInvokevirtual("java.lang.reflect.Method", METHOD_NAME, METHOD_DESCRIPTOR);
                        finish.mark();
                        it.writeByte(0, index);
                        it.writeByte(0, index + 1);
                        it.writeByte(0, index + 2);
                        it.insertEx(b.get());
                    }
                    m.getCodeAttribute().computeMaxStack();
                }
                catch (Exception e) {
                    log.error("Bad byte code transforming " + file.getName(), e);
                }
            }
            return true;
        }
        return false;
    }
}

