/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.manip.data.StaticFieldAccessRewriteData;
import org.fakereplace.manip.util.ManipulationDataStore;

public class StaticFieldManipulator
implements ClassManipulator {
    private static final Logger log = Logger.getLogger(StaticFieldManipulator.class);
    private final ManipulationDataStore<StaticFieldAccessRewriteData> data = new ManipulationDataStore();

    @Override
    public void clearRewrites(String className, ClassLoader classLoader) {
        this.data.remove(className, classLoader);
    }

    public void rewriteStaticFieldAccess(String oldClass, String newClass, String fieldName, ClassLoader classLoader) {
        this.data.add(oldClass, new StaticFieldAccessRewriteData(oldClass, newClass, fieldName, classLoader));
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        Map<String, Set<StaticFieldAccessRewriteData>> staticMethodData = this.data.getManipulationData(loader);
        if (staticMethodData.isEmpty()) {
            return false;
        }
        HashMap<Integer, StaticFieldAccessRewriteData> fieldAccessLocations = new HashMap<Integer, StaticFieldAccessRewriteData>();
        HashMap<StaticFieldAccessRewriteData, Integer> newFieldClassPoolLocations = new HashMap<StaticFieldAccessRewriteData, Integer>();
        HashMap<StaticFieldAccessRewriteData, Integer> newFieldAccessLocations = new HashMap<StaticFieldAccessRewriteData, Integer>();
        ConstPool pool = file.getConstPool();
        block2: for (int i = 1; i < pool.getSize(); ++i) {
            String className;
            if (pool.getTag(i) != 9 || !staticMethodData.containsKey(className = pool.getFieldrefClassName(i))) continue;
            String fieldName = pool.getFieldrefName(i);
            for (StaticFieldAccessRewriteData data : staticMethodData.get(className)) {
                if (!fieldName.equals(data.getFieldName())) continue;
                fieldAccessLocations.put(i, data);
                if (newFieldClassPoolLocations.containsKey(data)) continue block2;
                int newCpLoc = pool.addClassInfo(data.getNewClass());
                newFieldClassPoolLocations.put(data, newCpLoc);
                int newNameAndType = pool.getFieldrefNameAndType(i);
                newFieldAccessLocations.put(data, pool.addFieldrefInfo(newCpLoc, newNameAndType));
                continue block2;
            }
        }
        if (!newFieldClassPoolLocations.isEmpty()) {
            List methods = file.getMethods();
            for (MethodInfo m : methods) {
                try {
                    if (m.getCodeAttribute() == null) continue;
                    CodeIterator it = m.getCodeAttribute().iterator();
                    while (it.hasNext()) {
                        int val;
                        int index = it.next();
                        int op = it.byteAt(index);
                        if (op != 178 && op != 179 || !fieldAccessLocations.containsKey(val = it.s16bitAt(index + 1))) continue;
                        StaticFieldAccessRewriteData data = (StaticFieldAccessRewriteData)fieldAccessLocations.get(val);
                        it.write16bit((Integer)newFieldAccessLocations.get(data), index + 1);
                    }
                    m.getCodeAttribute().computeMaxStack();
                }
                catch (Exception e) {
                    log.error("Bad byte code transforming " + file.getName(), e);
                }
            }
            return true;
        }
        return false;
    }
}

