/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip.data;

import org.fakereplace.manip.util.ClassLoaderFiltered;
import org.fakereplace.util.DescriptorUtils;

public class ConstructorRewriteData
implements ClassLoaderFiltered<ConstructorRewriteData> {
    private final String clazz;
    private final String methodDesc;
    private final String[] parameters;
    private final int methodNo;
    private final ClassLoader classLoader;

    public ConstructorRewriteData(String clazz, String methodDesc, int methodNo, ClassLoader classLoader) {
        this.clazz = clazz;
        this.methodDesc = methodDesc;
        this.methodNo = methodNo;
        this.parameters = DescriptorUtils.descriptorStringToParameterArray(methodDesc);
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ConstructorRewriteData.class.getName() + " ");
        sb.append(this.clazz);
        sb.append(" ");
        sb.append(this.methodDesc);
        sb.append(" ");
        sb.append(this.methodNo);
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public int getMethodNo() {
        return this.methodNo;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ConstructorRewriteData getInstance() {
        return this;
    }
}

