/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.replacement;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.util.HashSet;
import java.util.Set;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassDataBuilder;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.Descriptor;
import org.fakereplace.logging.Logger;
import org.fakereplace.replacement.AnnotationReplacer;
import org.fakereplace.replacement.FieldReplacer;
import org.fakereplace.replacement.MethodReplacer;
import org.fakereplace.replacement.ReplacementResult;

public class ClassRedefiner {
    private static final Logger log = new Logger(ClassRedefiner.class);

    public static ReplacementResult rewriteLoadedClasses(ClassDefinition ... classDefinitions) {
        HashSet<ClassDefinition> defs = new HashSet<ClassDefinition>();
        HashSet changedClasses = new HashSet();
        HashSet classesToReload = new HashSet();
        for (int i = 0; i < classDefinitions.length; ++i) {
            try {
                ClassDefinition d = classDefinitions[i];
                ClassFile file = new ClassFile(new DataInputStream(new ByteArrayInputStream(d.getDefinitionClassFile())));
                ClassRedefiner.modifyReloadedClass(file, d.getDefinitionClass().getClassLoader(), d.getDefinitionClass(), classesToReload);
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                file.write(new DataOutputStream(bs));
                changedClasses.add(d.getDefinitionClass());
                ClassDefinition n = new ClassDefinition(d.getDefinitionClass(), bs.toByteArray());
                defs.add(n);
                continue;
            }
            catch (IOException e) {
                log.error("IO Error", e);
            }
        }
        classesToReload.removeAll(changedClasses);
        ClassDefinition[] ret = new ClassDefinition[defs.size()];
        int count = 0;
        for (ClassDefinition c : defs) {
            ret[count++] = c;
        }
        return new ReplacementResult(ret, classesToReload);
    }

    public static void modifyReloadedClass(ClassFile file, ClassLoader loader, Class<?> oldClass, Set<Class<?>> classToReload) {
        BaseClassData b = ClassDataStore.instance().getBaseClassData(loader, Descriptor.toJvmName(file.getName()));
        if (b == null) {
            throw new RuntimeException("Could not find BaseClassData for " + file.getName());
        }
        if (!file.getSuperclass().equals(b.getSuperClassName())) {
            System.out.println("Superclass changed from " + b.getSuperClassName() + " to " + file.getSuperclass() + " in class " + file.getName());
        }
        ClassDataBuilder builder = new ClassDataBuilder(b);
        AnnotationReplacer.processAnnotations(file, oldClass);
        FieldReplacer.handleFieldReplacement(file, loader, oldClass, builder);
        MethodReplacer.handleMethodReplacement(file, loader, oldClass, builder, classToReload);
        ClassDataStore.instance().saveClassData(loader, file.getName(), builder);
    }
}

