/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fakereplace.Agent;
import org.fakereplace.boot.DefaultEnvironment;
import org.fakereplace.logging.Logger;
import org.fakereplace.replacement.AddedClass;

public class FakereplaceProtocol {
    private static final Logger log = Logger.getLogger(FakereplaceProtocol.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Socket socket) {
        DataOutputStream output = null;
        try {
            log.trace("Fakereplace update is running");
            DataInputStream input = new DataInputStream(socket.getInputStream());
            output = new DataOutputStream(socket.getOutputStream());
            HashMap<String, Long> classes = new HashMap<String, Long>();
            HashMap<String, Long> resources = new HashMap<String, Long>();
            int magic = input.readInt();
            if (magic != -889266513) {
                System.err.println("Fakereplace server error, wrong magic number");
                return;
            }
            String archiveName = FakereplaceProtocol.readString(input);
            FakereplaceProtocol.readAvailable(input, classes);
            FakereplaceProtocol.readAvailable(input, resources);
            log.info("Fakereplace is checking for updates classes. Client sent " + classes.size() + "classes");
            Set<Class> classesToReplace = DefaultEnvironment.getEnvironment().getUpdatedClasses(archiveName, classes);
            HashMap<String, Class> classMap = new HashMap<String, Class>();
            output.writeInt(classesToReplace.size());
            for (Class clazz : classesToReplace) {
                String cname = clazz.getName();
                output.writeInt(cname.length());
                output.write(cname.getBytes());
                classMap.put(cname, clazz);
            }
            Set<String> resourcesToReplace = DefaultEnvironment.getEnvironment().getUpdatedResources(archiveName, resources);
            output.writeInt(resourcesToReplace.size());
            for (String cname : resourcesToReplace) {
                output.writeInt(cname.length());
                output.write(cname.getBytes());
            }
            output.flush();
            HashSet<ClassDefinition> classDefinitions = new HashSet<ClassDefinition>();
            HashSet replacedClasses = new HashSet();
            int noClasses = input.readInt();
            for (int i = 0; i < noClasses; ++i) {
                String className = FakereplaceProtocol.readString(input);
                int length = input.readInt();
                byte[] buffer = new byte[length];
                for (int j = 0; j < length; ++j) {
                    buffer[j] = (byte)input.read();
                }
                classDefinitions.add(new ClassDefinition((Class)classMap.get(className), buffer));
                replacedClasses.add(classMap.get(className));
            }
            HashMap<String, byte[]> replacedResources = new HashMap<String, byte[]>();
            int noResources = input.readInt();
            for (int i = 0; i < noResources; ++i) {
                String resourceName = FakereplaceProtocol.readString(input);
                int length = input.readInt();
                byte[] buffer = new byte[length];
                for (int j = 0; j < length; ++j) {
                    buffer[j] = (byte)input.read();
                }
                replacedResources.put(resourceName, buffer);
            }
            Agent.redefine(classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]), new AddedClass[0]);
            DefaultEnvironment.getEnvironment().updateResource(archiveName, replacedResources);
            output.writeInt(0);
        }
        catch (Exception e) {
            try {
                output.writeInt(1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            e.printStackTrace();
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readAvailable(DataInputStream input, Map<String, Long> resources) throws IOException {
        int noResources = input.readInt();
        for (int i = 0; i < noResources; ++i) {
            String resourceName = FakereplaceProtocol.readString(input);
            long ts = input.readLong();
            resources.put(resourceName, ts);
        }
    }

    private static String readString(DataInputStream input) throws IOException {
        int toread;
        byte[] buf = new byte[toread];
        int read = 0;
        for (toread = input.readInt(); toread > 0 && (read = input.read(buf, read, toread)) != -1; toread -= read) {
        }
        return new String(buf);
    }
}

