/*
 * Decompiled with CFR 0.152.
 */
package org.fastily.jwiki.core;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.fastily.jwiki.core.Wiki;

class ColorLog {
    private static final DateTimeFormatter df = DateTimeFormatter.ofPattern("MMM dd, yyyy hh:mm:ss a");
    protected boolean enabled;

    protected ColorLog(boolean enableLogging) {
        this.enabled = enableLogging;
    }

    private void log(Wiki wiki, String message, String logLevel, CC color) {
        if (this.enabled) {
            System.err.printf("%s%n%s: \u001b[3%dm%s: %s\u001b[0m%n", LocalDateTime.now().format(df), logLevel, color.v, wiki, message);
        }
    }

    protected void warn(Wiki wiki, String s) {
        this.log(wiki, s, "WARNING", CC.YELLOW);
    }

    protected void info(Wiki wiki, String s) {
        this.log(wiki, s, "INFO", CC.GREEN);
    }

    protected void error(Wiki wiki, String s) {
        this.log(wiki, s, "ERROR", CC.RED);
    }

    protected void debug(Wiki wiki, String s) {
        this.log(wiki, s, "DEBUG", CC.PURPLE);
    }

    protected void fyi(Wiki wiki, String s) {
        this.log(wiki, s, "FYI", CC.CYAN);
    }

    private static enum CC {
        BLACK(0),
        RED(1),
        GREEN(2),
        YELLOW(3),
        BLUE(4),
        PURPLE(5),
        CYAN(6),
        WHITE(7);

        private int v;

        private CC(int v) {
            this.v = v;
        }
    }
}

