/*
 * Decompiled with CFR 0.152.
 */
package org.fastily.jwiki.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fastily.jwiki.core.Wiki;
import org.fastily.jwiki.util.FL;
import org.fastily.jwiki.util.GSONP;

class WQuery {
    public static final QTemplate ALLOWEDFILEXTS = new QTemplate(FL.pMap("meta", "siteinfo", "siprop", "fileextensions"), "fileextensions");
    public static final QTemplate ALLPAGES = new QTemplate(FL.pMap("list", "allpages"), "aplimit", "allpages");
    public static final QTemplate CATEGORYINFO = new QTemplate(FL.pMap("prop", "categoryinfo", "titles", null), "categoryinfo");
    public static final QTemplate CATEGORYMEMBERS = new QTemplate(FL.pMap("list", "categorymembers", "cmtitle", null), "cmlimit", "categorymembers");
    public static final QTemplate NAMESPACES = new QTemplate(FL.pMap("meta", "siteinfo", "siprop", "namespaces|namespacealiases"), null);
    public static final QTemplate DUPLICATEFILES = new QTemplate(FL.pMap("prop", "duplicatefiles", "titles", null), "dflimit", "duplicatefiles");
    public static final QTemplate EXISTS = new QTemplate(FL.pMap("prop", "pageprops", "ppprop", "missing", "titles", null), null);
    public static final QTemplate EXTLINKS = new QTemplate(FL.pMap("prop", "extlinks", "elexpandurl", "1", "titles", null), "ellimit", "extlinks");
    public static final QTemplate FILEUSAGE = new QTemplate(FL.pMap("prop", "fileusage", "titles", null), "fulimit", "fileusage");
    public static final QTemplate GLOBALUSAGE = new QTemplate(FL.pMap("prop", "globalusage", "titles", null), "gulimit", "globalusage");
    public static final QTemplate IMAGES = new QTemplate(FL.pMap("prop", "images", "titles", null), "imlimit", "images");
    public static final QTemplate IMAGEINFO = new QTemplate(FL.pMap("prop", "imageinfo", "iiprop", "canonicaltitle|url|size|sha1|mime|user|timestamp|comment", "titles", null), "iilimit", "imageinfo");
    public static final QTemplate LINKSHERE = new QTemplate(FL.pMap("prop", "linkshere", "lhprop", "title", "lhshow", null, "titles", null), "lhlimit", "linkshere");
    public static final QTemplate LINKSONPAGE = new QTemplate(FL.pMap("prop", "links", "titles", null), "pllimit", "links");
    public static final QTemplate LOGEVENTS = new QTemplate(FL.pMap("list", "logevents"), "lelimit", "logevents");
    public static final QTemplate PAGECATEGORIES = new QTemplate(FL.pMap("prop", "categories", "titles", null), "cllimit", "categories");
    public static final QTemplate PAGETEXT = new QTemplate(FL.pMap("prop", "revisions", "rvprop", "content", "titles", null), null);
    public static final QTemplate PROTECTEDTITLES = new QTemplate(FL.pMap("list", "protectedtitles", "ptprop", "timestamp|level|user|comment"), "ptlimit", "protectedtitles");
    public static final QTemplate QUERYPAGES = new QTemplate(FL.pMap("list", "querypage", "qppage", null), "qplimit", "querypage");
    public static final QTemplate RANDOM = new QTemplate(FL.pMap("list", "random", "rnfilterredir", "nonredirects"), "rnlimit", "random");
    public static final QTemplate RECENTCHANGES = new QTemplate(FL.pMap("list", "recentchanges", "rcprop", "title|timestamp|user|comment", "rctype", "edit|new|log"), "rclimit", "recentchanges");
    public static final QTemplate RESOLVEREDIRECT = new QTemplate(FL.pMap("redirects", "", "titles", null), "redirects");
    public static final QTemplate REVISIONS = new QTemplate(FL.pMap("prop", "revisions", "rvprop", "comment|content|ids|timestamp|user", "titles", null), "rvlimit", "revisions");
    public static final QTemplate SEARCH = new QTemplate(FL.pMap("list", "search", "srprop", "", "srnamespace", "*", "srsearch", null), "srlimit", "search");
    public static final QTemplate TEMPLATES = new QTemplate(FL.pMap("prop", "templates", "tiprop", "title", "titles", null), "tllimit", "templates");
    public static final QTemplate TEXTEXTRACTS = new QTemplate(FL.pMap("prop", "extracts", "exintro", "1", "explaintext", "1", "titles", null), "exlimit", "extract");
    public static final QTemplate TOKENS_CSRF = new QTemplate(FL.pMap("meta", "tokens", "type", "csrf"), null);
    public static final QTemplate TOKENS_LOGIN = new QTemplate(FL.pMap("meta", "tokens", "type", "login"), null);
    public static final QTemplate TRANSCLUDEDIN = new QTemplate(FL.pMap("prop", "transcludedin", "tiprop", "title", "titles", null), "tilimit", "transcludedin");
    public static final QTemplate USERCONTRIBS = new QTemplate(FL.pMap("list", "usercontribs", "ucuser", null), "uclimit", "usercontribs");
    public static final QTemplate USERINFO = new QTemplate(FL.pMap("meta", "userinfo"), null);
    public static final QTemplate USERRIGHTS = new QTemplate(FL.pMap("list", "users", "usprop", "groups", "ususers", null), "users");
    public static final QTemplate USERUPLOADS = new QTemplate(FL.pMap("list", "allimages", "aisort", "timestamp", "aiuser", null), "ailimit", "allimages");
    private static Type strMapT = new TypeToken<HashMap<String, String>>(){}.getType();
    private final HashMap<String, String> pl = FL.pMap("action", "query", "format", "json");
    private final ArrayList<String> limStrList = new ArrayList();
    private final Wiki wiki;
    private boolean canCont = true;
    private int queryLimit;
    private int totalLimit = -1;
    private int currCount = 0;

    public WQuery(Wiki wiki, QTemplate ... qut) {
        this.wiki = wiki;
        this.queryLimit = wiki.conf.maxResultLimit;
        for (QTemplate qt : qut) {
            this.pl.putAll(qt.defaultFields);
            if (qt.limString == null) continue;
            this.limStrList.add(qt.limString);
        }
    }

    public WQuery(Wiki wiki, int totalLimit, QTemplate ... qut) {
        this(wiki, qut);
        this.totalLimit = totalLimit;
    }

    public boolean has() {
        return this.canCont;
    }

    public QReply next() {
        if (this.pl.containsValue(null)) {
            throw new IllegalStateException(String.format("Fill in *all* the null fields -> %s", this.pl));
        }
        if (!this.canCont) {
            return null;
        }
        try {
            JsonObject result;
            if (this.totalLimit > 0 && (this.currCount += this.queryLimit) > this.totalLimit) {
                this.adjustLimit(this.queryLimit - (this.currCount - this.totalLimit));
                this.canCont = false;
            }
            if ((result = JsonParser.parseString((String)this.wiki.apiclient.basicGET(this.pl).body().string()).getAsJsonObject()).has("continue")) {
                this.pl.putAll((Map)GSONP.gson.fromJson((JsonElement)result.getAsJsonObject("continue"), strMapT));
            } else {
                this.canCont = false;
            }
            if (this.wiki.debug) {
                this.wiki.conf.log.debug(this.wiki, GSONP.gsonPP.toJson((JsonElement)result));
            }
            return new QReply(result);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public WQuery set(String key, String value) {
        this.pl.put(key, value);
        return this;
    }

    public WQuery set(String key, List<String> values) {
        return this.set(key, FL.pipeFence(values));
    }

    public WQuery adjustLimit(int limit) {
        Object limitString;
        if (limit <= 0 || limit > this.wiki.conf.maxResultLimit) {
            limitString = "max";
            this.queryLimit = this.wiki.conf.maxResultLimit;
        } else {
            limitString = "" + limit;
            this.queryLimit = limit;
        }
        for (String s : this.limStrList) {
            this.pl.put(s, (String)limitString);
        }
        return this;
    }

    protected static class QTemplate {
        private final HashMap<String, String> defaultFields;
        private final String limString;
        protected final String id;

        public QTemplate(HashMap<String, String> defaultFields, String id) {
            this(defaultFields, null, id);
        }

        public QTemplate(HashMap<String, String> defaultFields, String limString, String id) {
            this.defaultFields = defaultFields;
            this.id = id;
            this.limString = limString;
            if (limString != null) {
                defaultFields.put(limString, "max");
            }
        }
    }

    protected static class QReply {
        protected static final ArrayList<String> defaultPropPTJ = FL.toSAL("query", "pages");
        private HashMap<String, String> normalized = null;
        protected final JsonObject input;

        private QReply(JsonObject input) {
            this.input = input;
            if (GSONP.nestedHas(input, FL.toSAL("query", "normalized"))) {
                this.normalized = GSONP.pairOff(GSONP.getJAofJO(GSONP.getNestedJA(input, FL.toSAL("query", "normalized"))), "from", "to");
            }
        }

        protected ArrayList<JsonObject> listComp(String k) {
            return this.input.has("query") ? GSONP.getJAofJO(this.input.getAsJsonObject("query"), k) : new ArrayList<JsonObject>();
        }

        protected HashMap<String, JsonElement> propComp(String kk, String vk) {
            HashMap<String, JsonElement> m = new HashMap<String, JsonElement>();
            JsonObject x = GSONP.getNestedJO(this.input, defaultPropPTJ);
            if (x == null) {
                return m;
            }
            for (JsonObject jo : GSONP.getJOofJO(x)) {
                m.put(GSONP.getStr(jo, kk), jo.get(vk));
            }
            return this.normalize(m);
        }

        protected JsonElement metaComp(String k) {
            return this.input.has("query") ? this.input.getAsJsonObject("query").get(k) : new JsonObject();
        }

        protected <V> HashMap<String, V> normalize(HashMap<String, V> m) {
            if (this.normalized != null) {
                this.normalized.forEach((f, t) -> {
                    if (m.containsKey(t)) {
                        m.put((String)f, m.get(t));
                    }
                });
            }
            return m;
        }
    }
}

