/*
 * Decompiled with CFR 0.152.
 */
package org.fastily.jwiki.dwrap;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.fastily.jwiki.util.GSONP;

public class PageSection {
    public final String header;
    public final int level;
    public final String text;

    private PageSection(String header, int level, String text) {
        this.header = header;
        this.level = level;
        this.text = text;
    }

    private PageSection(JsonObject jo, String text) {
        this(GSONP.getStr(jo, "line"), Integer.parseInt(GSONP.getStr(jo, "level")), text);
    }

    public static ArrayList<PageSection> pageBySection(ArrayList<JsonObject> jl, String text) {
        ArrayList<PageSection> psl = new ArrayList<PageSection>();
        if (text.isEmpty()) {
            return psl;
        }
        if (jl.isEmpty()) {
            psl.add(new PageSection(null, -1, text));
            return psl;
        }
        JsonObject first = jl.get(0);
        int firstOffset = PageSection.offsetOf(first);
        if (firstOffset > 0) {
            psl.add(new PageSection(null, -1, text.substring(0, firstOffset)));
        }
        if (jl.size() == 1) {
            psl.add(new PageSection(first, text.substring(PageSection.offsetOf(first))));
        } else {
            for (int i = 0; i < jl.size() - 1; ++i) {
                JsonObject curr = jl.get(i);
                psl.add(new PageSection(curr, text.substring(PageSection.offsetOf(curr), PageSection.offsetOf(jl.get(i + 1)))));
            }
            JsonObject last = jl.get(jl.size() - 1);
            psl.add(new PageSection(last, text.substring(PageSection.offsetOf(last))));
        }
        return psl;
    }

    private static int offsetOf(JsonObject jo) {
        return jo.get("byteoffset").getAsInt();
    }
}

