/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fastnate.data.DataProvider;
import org.fastnate.generator.ConnectedEntitySqlGenerator;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.WriterEntitySqlGenerator;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.ModelException;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityImporter {
    private static final Logger log = LoggerFactory.getLogger(EntityImporter.class);
    public static final String GENERATION_ABORTED_MESSAGE = "!!! GENERATION ABORTED !!!";
    public static final String DATA_FOLDER_KEY = "fastnate.data.folder";
    public static final String OUTPUT_FILE_KEY = "fastnate.data.sql.output.file";
    public static final String OUTPUT_ENCODING_KEY = "fastnate.data.sql.output.encoding";
    public static final String PREFIX_KEY = "fastnate.data.sql.prefix";
    public static final String POSTFIX_KEY = "fastnate.data.sql.postfix";
    public static final String PACKAGES_KEY = "fastnate.data.provider.packages";
    private final Properties settings;
    private final File dataFolder;
    private final GeneratorContext context;
    private final List<DataProvider> dataProviders = new ArrayList<DataProvider>();

    public static void main(String[] args) throws IOException {
        Properties settings = new Properties(System.getProperties());
        if (args.length > 0) {
            if (new File(args[0]).isDirectory()) {
                settings.put(DATA_FOLDER_KEY, args[0]);
                if (args.length > 1) {
                    settings.put(OUTPUT_FILE_KEY, args[1]);
                }
            } else {
                settings.put(OUTPUT_FILE_KEY, args[0]);
                if (args.length > 1) {
                    settings.put(DATA_FOLDER_KEY, args[1]);
                }
            }
        }
        new EntityImporter(settings).importData();
    }

    public EntityImporter() {
        this(new Properties());
    }

    public EntityImporter(Properties settings) {
        this(settings, new File(settings.getProperty(DATA_FOLDER_KEY, ".")), new GeneratorContext(settings));
    }

    public EntityImporter(Properties settings, File dataFolder, GeneratorContext context) {
        this.settings = settings;
        this.dataFolder = dataFolder;
        this.context = context;
        this.setup();
    }

    private boolean addProvider(Constructor<?> constructor) {
        int maxOrder = Integer.MIN_VALUE;
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] params = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType == File.class) {
                params[i] = this.dataFolder;
                continue;
            }
            if (parameterType == Properties.class) {
                params[i] = this.settings;
                continue;
            }
            DataProvider parameter = this.findProvider(parameterType);
            if (parameter == null) {
                return false;
            }
            params[i] = parameter;
            int order = parameter.getOrder();
            if (order <= maxOrder) continue;
            maxOrder = order;
        }
        try {
            int index;
            DataProvider provider = (DataProvider)constructor.newInstance(params);
            int order = Math.max(maxOrder, provider.getOrder());
            for (index = this.dataProviders.size(); index > 0 && this.dataProviders.get(index - 1).getOrder() > order; --index) {
            }
            this.dataProviders.add(index, provider);
            return true;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DataProvider findProvider(Class<?> dataType) {
        for (DataProvider provider : this.dataProviders) {
            if (!dataType.isInstance(provider)) continue;
            return provider;
        }
        return null;
    }

    private Charset getEncoding() {
        return Charset.forName(this.settings.getProperty(OUTPUT_ENCODING_KEY, "UTF-8"));
    }

    public void importData() throws IOException {
        this.importData(new File(this.settings.getProperty(OUTPUT_FILE_KEY, "data.sql")));
    }

    public void importData(Connection connection) throws IOException, SQLException {
        try (ConnectedEntitySqlGenerator generator = new ConnectedEntitySqlGenerator(connection, this.context);){
            this.importData((EntitySqlGenerator)generator);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    public void importData(EntitySqlGenerator generator) throws IOException {
        try {
            String dialect = this.context.getDialect().getClass().getSimpleName();
            log.info("Using {} for SQL generation.", (Object)dialect);
            for (DataProvider provider : this.dataProviders) {
                provider.buildEntities();
            }
            generator.writeComment("Generated by FastNate EntityImporter for " + dialect);
            this.writePropertyPart(generator, PREFIX_KEY);
            for (DataProvider provider : this.dataProviders) {
                generator.writeSectionSeparator();
                generator.writeComment("Data from " + provider.getClass().getSimpleName());
                provider.writeEntities(generator);
                log.info("Generated SQL for {}", provider.getClass());
            }
            generator.writeAlignmentStatements();
            this.writePropertyPart(generator, POSTFIX_KEY);
        }
        catch (IOException | Error | RuntimeException e) {
            generator.writeSectionSeparator();
            StringWriter buffer = new StringWriter();
            buffer.write("\n!!! GENERATION ABORTED !!!\n");
            e.printStackTrace(new PrintWriter((Writer)buffer, true));
            generator.writeComment(buffer.toString());
            throw e;
        }
    }

    public void importData(File targetFile) throws IOException {
        File directory = targetFile.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.getEncoding()));){
            this.importData(writer);
            log.info("'{}' generated.", (Object)targetFile.getAbsolutePath());
        }
    }

    public void importData(Writer writer) throws IOException {
        try (WriterEntitySqlGenerator generator = new WriterEntitySqlGenerator(writer, this.context);){
            this.importData((EntitySqlGenerator)generator);
        }
    }

    private void setup() {
        log.info("Searching for implementations of " + DataProvider.class.getSimpleName());
        String packages = EntityImporter.class.getPackage().getName() + ";" + this.settings.getProperty(PACKAGES_KEY, "").trim();
        Reflections reflections = new Reflections((Object[])packages.split("[\\s;,:]+"));
        ArrayList providers = new ArrayList(reflections.getSubTypesOf(DataProvider.class));
        Collections.sort(providers, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
        while (!providers.isEmpty()) {
            int previousSize = providers.size();
            Iterator iterator = providers.iterator();
            block1: while (iterator.hasNext()) {
                Class providerClass = (Class)iterator.next();
                if (Modifier.isAbstract(providerClass.getModifiers())) {
                    iterator.remove();
                    continue;
                }
                Constructor<?>[] constructors = providerClass.getConstructors();
                ModelException.test((constructors.length > 0 ? 1 : 0) != 0, (String)"No public constructor found for {}", (Object[])new Object[]{providerClass});
                for (Constructor<?> constructor : constructors) {
                    if (!this.addProvider(constructor)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            ModelException.test((previousSize > providers.size() ? 1 : 0) != 0, (String)"Can't create the following provides (possibly because of circular dependencies): {}", (Object[])new Object[]{providers});
        }
    }

    private void writePropertyPart(EntitySqlGenerator generator, String property) throws IOException {
        if (!(generator instanceof WriterEntitySqlGenerator)) {
            return;
        }
        Writer writer = ((WriterEntitySqlGenerator)generator).getWriter();
        String propertyValue = StringUtils.trimToNull((String)this.settings.getProperty(property));
        if (propertyValue != null) {
            generator.writeSectionSeparator();
            if (propertyValue.endsWith(".sql")) {
                String[] fileNames;
                for (String fileName : fileNames = propertyValue.split("[\\n\\" + File.pathSeparatorChar + ",;]+")) {
                    File sqlFile = new File(fileName);
                    if (!sqlFile.isAbsolute()) {
                        sqlFile = new File(this.dataFolder, fileName);
                    }
                    if (sqlFile.isFile()) {
                        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(sqlFile), this.getEncoding());){
                            generator.writeComment(fileName);
                            IOUtils.copy((Reader)input, (Writer)writer);
                            writer.write("\n");
                            continue;
                        }
                    }
                    generator.writeComment("Ignored missing file: " + fileName);
                }
            } else {
                generator.writeComment(property);
                writer.write(propertyValue);
                writer.write("\n");
            }
        }
    }

    public Properties getSettings() {
        return this.settings;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public List<DataProvider> getDataProviders() {
        return this.dataProviders;
    }
}

