/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentMatches;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public abstract class AbstractCsvReader<R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCsvReader.class);
    private final List<File> importFiles = new ArrayList<File>();

    private static boolean isNotEmpty(List<String> values) {
        return values.size() > 1 || values.size() == 1 && StringUtils.isNotBlank((String)values.get(0));
    }

    public AbstractCsvReader(File importPath) {
        if (!importPath.exists()) {
            throw new IllegalArgumentException("Path not found: " + importPath.getAbsolutePath());
        }
        if (importPath.isDirectory()) {
            this.importFiles.addAll(Arrays.asList(importPath.listFiles((FilenameFilter)new SuffixFileFilter(".csv"))));
        } else {
            this.importFiles.add(importPath);
        }
    }

    protected abstract Collection<? extends R> createEntities(Map<String, String> var1);

    protected Charset getDefaultEncoding() {
        return StandardCharsets.UTF_8;
    }

    protected CsvListReader openCsvListReader(File importFile) throws IOException {
        String charset;
        BOMInputStream inputStream;
        InputStream fileStream = new FileInputStream(importFile);
        if (importFile.getName().toLowerCase().endsWith(".gz")) {
            fileStream = new GZIPInputStream(fileStream);
        }
        if ((inputStream = new BOMInputStream(fileStream, false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE})).hasBOM()) {
            charset = inputStream.getBOMCharsetName();
            log.info("BOM detected. Using {} as encoding", (Object)charset);
        } else {
            charset = this.getDefaultEncoding().toString();
            log.info("No BOM detected. Assuming {} as encoding", (Object)charset);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);
        return new CsvListReader((Reader)reader, new CsvPreference.Builder(CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE).skipComments((CommentMatcher)new CommentMatches("(//|/\\*|#|;).*")).build());
    }

    protected Collection<R> readImportFiles() throws IOException {
        ArrayList<R> entities = new ArrayList<R>();
        for (File importFile : this.importFiles) {
            log.info("Reading entities from {}...", (Object)importFile);
            CsvListReader csvList = this.openCsvListReader(importFile);
            Throwable throwable = null;
            try {
                List values;
                Object[] header = csvList.getHeader(true);
                if (ArrayUtils.isEmpty((Object[])header)) {
                    log.error("Ignoring {}, as no header was found", (Object)importFile);
                    continue;
                }
                HashMap<Object, Integer> columnNames = new HashMap<Object, Integer>();
                for (int i = 0; i < header.length; ++i) {
                    if (header[i] == null) continue;
                    columnNames.put(header[i], i);
                }
                while ((values = csvList.read()) != null) {
                    if (!AbstractCsvReader.isNotEmpty(values)) continue;
                    HashMap<String, String> row = new HashMap<String, String>();
                    for (Map.Entry column : columnNames.entrySet()) {
                        if ((Integer)column.getValue() >= values.size()) continue;
                        row.put((String)column.getKey(), (String)values.get((Integer)column.getValue()));
                    }
                    entities.addAll(this.createEntities(row));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (csvList == null) continue;
                if (throwable != null) {
                    try {
                        csvList.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                csvList.close();
            }
        }
        return entities;
    }
}

