/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.text.Format;
import java.text.ParseException;
import org.fastnate.data.csv.CsvPropertyConverter;

public class CsvFormatConverter<T>
implements CsvPropertyConverter<T> {
    private final Format[] formats;

    public CsvFormatConverter(Format ... formats) {
        this.formats = formats;
    }

    @Override
    public T convert(Class<? extends T> targetType, String value) {
        if (value == null) {
            return null;
        }
        ParseException firstError = null;
        for (Format format : this.formats) {
            try {
                return (T)format.parseObject(value);
            }
            catch (ParseException e) {
                if (firstError != null) continue;
                firstError = e;
            }
        }
        throw new IllegalArgumentException(value, firstError);
    }
}

