/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.examples.data;

import java.io.IOException;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Resource;
import org.fastnate.data.AbstractDataProvider;
import org.fastnate.data.EntityRegistration;
import org.fastnate.data.csv.CsvDataImporter;
import org.fastnate.data.files.DataFolder;
import org.fastnate.data.properties.FormatConverter;
import org.fastnate.data.properties.MapConverter;
import org.fastnate.data.properties.PropertyConverter;
import org.fastnate.examples.model.Organisation;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorContext;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentStartsWith;
import org.supercsv.prefs.CsvPreference;

public class OrganisationData
extends AbstractDataProvider {
    @Resource
    private DataFolder dataFolder;
    @Resource
    private GeneratorContext context;
    @Resource
    private EntityRegistration entityRegistration;
    private final Map<String, Organisation> organisations = new LinkedHashMap<String, Organisation>();

    public void buildEntities() throws IOException {
        CsvPreference csvSettings = new CsvPreference.Builder(CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE).skipComments((CommentMatcher)new CommentStartsWith("#")).build();
        EntityClass entityClass = this.context.getDescription(Organisation.class);
        CsvDataImporter importer = new CsvDataImporter(entityClass, csvSettings, this.entityRegistration);
        importer.addDefaultColumnMapping("id");
        importer.addDefaultColumnMapping("name");
        importer.addColumnMapping("web", Organisation::setUrl);
        importer.addColumnMapping("profit", Float.TYPE, (PropertyConverter)new FormatConverter(new Format[]{NumberFormat.getCurrencyInstance(Locale.US)}), Organisation::setProfit);
        importer.addColumnMapping("parent", (Function)MapConverter.create(this.organisations), Organisation::setParent);
        importer.addIgnoredColumn("comment");
        importer.addPostProcessor(organisation -> this.organisations.put(organisation.getName(), (Organisation)organisation));
        importer.importFile(this.dataFolder.findFile("organisations.csv"));
    }

    protected Collection<?> getEntities() {
        return this.organisations.values();
    }

    public DataFolder getDataFolder() {
        return this.dataFolder;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public EntityRegistration getEntityRegistration() {
        return this.entityRegistration;
    }

    public Map<String, Organisation> getOrganisations() {
        return this.organisations;
    }
}

