/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.examples.model;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.fastnate.examples.model.Organisation;

@Entity
public class Person {
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false)
    private String firstName;
    @NotNull
    private String lastName;
    @ManyToOne
    private Organisation organisation;
    @ManyToMany
    private final Collection<Organisation> previousOrganisations = new HashSet<Organisation>();
    @ManyToOne
    private Person supervisor;
    @OneToMany(mappedBy="supervisor")
    private final Collection<Person> subordinates = new HashSet<Person>();
    @Temporal(value=TemporalType.DATE)
    private Date entryDate;
    private boolean active;

    public Person(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public void setSupervisor(Person supervisor) {
        if (this.supervisor != null) {
            this.supervisor.getSubordinates().remove(this);
        }
        this.supervisor = supervisor;
        if (supervisor != null) {
            supervisor.getSubordinates().add(this);
        }
    }

    public String toString() {
        return this.firstName + ' ' + this.lastName;
    }

    public Long getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public Collection<Organisation> getPreviousOrganisations() {
        return this.previousOrganisations;
    }

    public Person getSupervisor() {
        return this.supervisor;
    }

    public Collection<Person> getSubordinates() {
        return this.subordinates;
    }

    public Date getEntryDate() {
        return this.entryDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Person() {
    }
}

