/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.ContextModelListener;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.SequenceIdGenerator;
import org.fastnate.generator.statements.EntityStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedEntitySqlGenerator
extends EntitySqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ConnectedEntitySqlGenerator.class);
    private static final long MILLISECONDS_BETWEEN_LOG_MESSAGES = 60000L;
    private final Connection connection;
    private final Statement statement;
    private long lastLogTime;
    private long statementsCount;

    private static String trimStatement(String sql) {
        char c;
        int start;
        int end = sql.length();
        for (start = 0; start < end && ((c = sql.charAt(start)) == ';' || Character.isWhitespace(c)); ++start) {
        }
        while (start < end) {
            c = sql.charAt(end - 1);
            if (c == ';') {
                String endKeyword = "end;";
                if (sql.regionMatches(true, end - "end;".length(), "end;", 0, "end;".length())) {
                    break;
                }
            } else if (!Character.isWhitespace(c)) break;
            --end;
        }
        return sql.substring(start, end);
    }

    public ConnectedEntitySqlGenerator(Connection connection) throws SQLException {
        this(connection, new GeneratorContext());
    }

    public ConnectedEntitySqlGenerator(Connection connection, final GeneratorContext context) throws SQLException {
        super(context);
        Statement sharedStatement;
        this.connection = connection;
        this.statement = sharedStatement = connection.createStatement();
        context.addContextModelListener(new ContextModelListener(){

            @Override
            public void foundEntityClass(EntityClass<?> entityClass) {
            }

            @Override
            public void foundGenerator(IdGenerator generator) {
                block17: {
                    if (!context.isWriteRelativeIds()) {
                        String sql = generator.getExpression(null, null, generator.getCurrentValue(), false);
                        sql = sql.matches("(SELECT\\W.*)") ? sql.substring(1, sql.length() - 1) : "SELECT (" + sql + ") currentValue " + context.getDialect().getOptionalTable();
                        try (ResultSet resultSet = sharedStatement.executeQuery(sql);){
                            if (resultSet.next()) {
                                long currentValue = resultSet.getLong(1);
                                if (!resultSet.wasNull()) {
                                    generator.setCurrentValue(currentValue);
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (generator instanceof SequenceIdGenerator) break block17;
                            throw new IllegalStateException("Can't initialize generator with " + sql, e);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        log.info("{} SQL statements successfully executed", (Object)this.statementsCount);
        super.close();
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void writeComment(String comment) throws IOException {
    }

    @Override
    public void writeSectionSeparator() throws IOException {
    }

    @Override
    public void writeStatement(EntityStatement stmt) throws IOException {
        String sql = ConnectedEntitySqlGenerator.trimStatement(this.getContext().getDialect().createSql(stmt));
        try {
            this.statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new IOException("Could not execute statement: " + sql, e);
        }
        ++this.statementsCount;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogTime >= 60000L) {
            this.lastLogTime = currentTime;
            if (this.statementsCount > 1L) {
                log.info("{} SQL statements executed", (Object)this.statementsCount);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public long getStatementsCount() {
        return this.statementsCount;
    }
}

