/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator;

import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fastnate.generator.context.EmbeddedProperty;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratedIdProperty;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;

public abstract class EntitySqlGenerator
implements Closeable {
    private final GeneratorContext context;

    private static <E> boolean isPostponedInsert(List<Object> postInsertEntities, E entity) {
        boolean isPostInsert;
        int index = postInsertEntities.indexOf(entity);
        boolean bl = isPostInsert = index >= 0;
        if (isPostInsert && index == postInsertEntities.size() - 1) {
            throw new IllegalArgumentException("An entity requires another entity that itself requires the first one.");
        }
        return isPostInsert;
    }

    @Override
    public void close() throws IOException {
        this.writeAlignmentStatements();
    }

    protected <E> boolean findEntity(E entity) throws IOException {
        return false;
    }

    public <E> void markExistingEntities(Iterable<E> entities) throws IOException {
        for (E entity : entities) {
            this.context.getDescription(entity).markExistingEntity(entity);
        }
    }

    public <E> void markExistingEntity(E entity, Number id) {
        ((GeneratedIdProperty)this.context.getDescription(entity).getIdProperty()).markReference(entity, id.longValue());
    }

    public <E> void write(E entity) throws IOException {
        this.write(entity, new ArrayList<Object>());
    }

    private <E> void write(E entity, List<Object> postponedEntities) throws IOException {
        EntityClass<E> classDescription = this.context.getDescription(entity);
        if (classDescription.isNew(entity)) {
            if (!this.findEntity(entity) && !EntitySqlGenerator.isPostponedInsert(postponedEntities, entity)) {
                postponedEntities.add(entity);
            }
            this.writeTableEntities(entity, postponedEntities, classDescription.getAllProperties());
            if (postponedEntities.remove(entity)) {
                this.writeInserts(entity, postponedEntities, classDescription, classDescription.getDiscriminator());
            }
        }
    }

    public <E> void write(Iterable<? extends E> entities) throws IOException {
        for (E entity : entities) {
            this.write(entity);
        }
    }

    public void writeAlignmentStatements() throws IOException {
        for (EntityStatement statement : this.context.getAlignmentStatements()) {
            this.writeStatement(statement);
        }
    }

    public abstract void writeComment(String var1) throws IOException;

    private <E> void writeInserts(E entity, List<Object> postponedEntities, EntityClass<E> classDescription, String discriminator) throws IOException {
        InsertStatement stmt = new InsertStatement(classDescription.getTable());
        if (classDescription.getJoinedParentClass() != null) {
            this.writeInserts(entity, postponedEntities, classDescription.getJoinedParentClass(), discriminator);
            stmt.addValue(classDescription.getPrimaryKeyJoinColumn(), classDescription.getEntityReference(entity, null, false));
        } else {
            this.writeStatements(classDescription.getIdProperty().createPreInsertStatements(entity));
            classDescription.getIdProperty().addInsertExpression(entity, stmt);
            if (discriminator != null) {
                stmt.addValue(classDescription.getDiscriminatorColumn(), discriminator);
            }
        }
        for (Property<E, ?> property : classDescription.getProperties().values()) {
            this.writeStatements(property.createPreInsertStatements(entity));
            property.addInsertExpression(entity, stmt);
        }
        this.writeStatement(stmt);
        this.writeStatements(classDescription.createPostInsertStatements(entity));
        for (Property<E, ?> property : classDescription.getProperties().values()) {
            for (Object referencedEntity : property.findReferencedEntities(entity)) {
                if (referencedEntity == null || postponedEntities.contains(referencedEntity)) continue;
                this.write(referencedEntity, postponedEntities);
            }
            this.writeStatements(property.createPostInsertStatements(entity));
        }
    }

    public abstract void writeSectionSeparator() throws IOException;

    public abstract void writeStatement(EntityStatement var1) throws IOException;

    private void writeStatements(List<? extends EntityStatement> statements) throws IOException {
        for (EntityStatement entityStatement : statements) {
            this.writeStatement(entityStatement);
        }
    }

    private <E, T> void writeTableEntities(E entity, List<Object> postponedEntities, Collection<Property<? super E, ?>> properties) throws IOException {
        for (Property<E, ?> property : properties) {
            if (property instanceof EmbeddedProperty) {
                EmbeddedProperty embeddedProperty = (EmbeddedProperty)property;
                this.writeTableEntities(embeddedProperty.getValue(entity), postponedEntities, embeddedProperty.getEmbeddedProperties().values());
                continue;
            }
            if (!property.isTableColumn()) continue;
            for (Object value : property.findReferencedEntities(entity)) {
                if (postponedEntities.contains(value) && !property.isRequired()) continue;
                this.write(value, postponedEntities);
            }
        }
    }

    @ConstructorProperties(value={"context"})
    public EntitySqlGenerator(GeneratorContext context) {
        this.context = context;
    }

    public GeneratorContext getContext() {
        return this.context;
    }
}

