/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.statements.EntityStatement;

public class WriterEntitySqlGenerator
extends EntitySqlGenerator {
    private final Writer writer;

    public WriterEntitySqlGenerator(Writer writer) {
        this(writer, new GeneratorContext());
    }

    public WriterEntitySqlGenerator(Writer writer, GeneratorContext context) {
        super(context);
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        Closeables.close((Closeable)this.writer, (boolean)false);
    }

    @Override
    public void writeComment(String comment) throws IOException {
        this.writer.write("/* " + comment + " */\n");
    }

    @Override
    public void writeSectionSeparator() throws IOException {
        this.writer.write(10);
    }

    @Override
    public void writeStatement(EntityStatement stmt) throws IOException {
        this.writer.write(this.getContext().getDialect().createSql(stmt));
    }

    public Writer getWriter() {
        return this.writer;
    }
}

