/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.persistence.AccessType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.ModelException;
import org.hibernate.annotations.Formula;

public enum AccessStyle {
    FIELD{

        @Override
        public <E> Iterable<AttributeAccessor> getDeclaredAttributes(Class<E> inspectedClass) {
            ArrayList<AttributeAccessor> result = new ArrayList<AttributeAccessor>();
            for (Field field : inspectedClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                result.add(new Accessor(field));
            }
            return result;
        }

        final class Accessor
        implements AttributeAccessor {
            private final Field field;
            private final String name;

            Accessor(Field field) {
                this.field = field;
                this.name = field.getName();
            }

            @Override
            public AccessStyle getAccessStyle() {
                return FIELD;
            }

            public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
                return this.field.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return this.field.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.field.getDeclaredAnnotations();
            }

            @Override
            public AnnotatedElement getElement() {
                return this.field;
            }

            @Override
            public Type getGenericType() {
                return this.field.getGenericType();
            }

            @Override
            public Class<?> getType() {
                return this.field.getType();
            }

            @Override
            public <E, T> T getValue(E entity) {
                if (entity == null) {
                    return null;
                }
                try {
                    if (!this.field.isAccessible()) {
                        this.field.setAccessible(true);
                    }
                    return (T)this.field.get(entity);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean isPersistent() {
                int modifiers = this.field.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !this.isAnnotationPresent(Transient.class) && !this.isAnnotationPresent(Formula.class);
            }

            @Override
            public <E, T> void setValue(E entity, T value) {
                try {
                    if (!this.field.isAccessible()) {
                        this.field.setAccessible(true);
                    }
                    this.field.set(entity, value);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return this.field.toString();
            }

            public Field getField() {
                return this.field;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }
    }
    ,
    METHOD{

        @Override
        public <E> Iterable<AttributeAccessor> getDeclaredAttributes(Class<E> inspectedClass) {
            ArrayList<AttributeAccessor> result = new ArrayList<AttributeAccessor>();
            for (Method method : inspectedClass.getDeclaredMethods()) {
                String name;
                if (Modifier.isStatic(method.getModifiers()) || !(name = method.getName()).startsWith("get") && !name.startsWith("is")) continue;
                result.add(new Accessor(method));
            }
            return result;
        }

        final class Accessor
        implements AttributeAccessor {
            private final Method method;
            private Method setter;
            private final String name;

            Accessor(Method getter) {
                this.method = getter;
                this.name = Introspector.decapitalize(getter.getName().replaceAll("^get|is", ""));
            }

            @Override
            public AccessStyle getAccessStyle() {
                return METHOD;
            }

            public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
                return this.method.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return this.method.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.method.getDeclaredAnnotations();
            }

            @Override
            public AnnotatedElement getElement() {
                return this.method;
            }

            @Override
            public Type getGenericType() {
                return this.method.getGenericReturnType();
            }

            @Override
            public Class<?> getType() {
                return this.method.getReturnType();
            }

            @Override
            public <E, T> T getValue(E entity) {
                if (entity == null) {
                    return null;
                }
                try {
                    if (!this.method.isAccessible()) {
                        this.method.setAccessible(true);
                    }
                    return (T)this.method.invoke(entity, new Object[0]);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    throw new IllegalStateException("Could not execute " + this.method + " on " + entity + ": " + e, e);
                }
            }

            @Override
            public boolean isPersistent() {
                int modifiers = this.method.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !this.isAnnotationPresent(Transient.class) && !this.isAnnotationPresent(Formula.class);
            }

            @Override
            public <E, T> void setValue(E entity, T value) {
                try {
                    if (this.setter == null) {
                        String setterName = "set" + StringUtils.capitalize((String)this.name);
                        Class<?> paramType = this.method.getReturnType();
                        for (Method m : this.method.getDeclaringClass().getDeclaredMethods()) {
                            if (!m.getName().equals(setterName) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != paramType) continue;
                            this.setter = m;
                            break;
                        }
                        if (this.setter == null) {
                            throw new ModelException("Can't find setter: " + this.method.getDeclaringClass() + '.' + setterName + '(' + paramType + ')');
                        }
                        if (!this.setter.isAccessible()) {
                            this.setter.setAccessible(true);
                        }
                    }
                    this.setter.invoke(entity, value);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return this.method.toString();
            }

            @Override
            public String getName() {
                return this.name;
            }
        }
    };


    public static AccessStyle getStyle(AccessType type) {
        return type == AccessType.FIELD ? FIELD : METHOD;
    }

    public abstract <E> Iterable<AttributeAccessor> getDeclaredAttributes(Class<E> var1);
}

