/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.PluralProperty;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;
import org.fastnate.generator.statements.TableStatement;
import org.fastnate.generator.statements.UpdateStatement;

public class CollectionProperty<E, T>
extends PluralProperty<E, Collection<T>, T> {
    private final String mappedBy;
    private final Class<T> targetClass;
    private final EntityClass<T> targetEntityClass;
    private final ValueConverter<T> targetConverter;
    private final String table;
    private String idColumn;
    private final String valueColumn;
    private final String orderColumn;
    private final boolean useTargetTable;

    private static String buildOrderColumn(AttributeAccessor attribute) {
        OrderColumn orderColumnDef = attribute.getAnnotation(OrderColumn.class);
        return orderColumnDef == null ? null : (orderColumnDef.name().length() == 0 ? attribute.getName() + "_ORDER" : orderColumnDef.name());
    }

    static boolean isCollectionProperty(AttributeAccessor attribute) {
        return (attribute.isAnnotationPresent(OneToMany.class) || attribute.isAnnotationPresent(ManyToMany.class) || attribute.isAnnotationPresent(ElementCollection.class)) && Collection.class.isAssignableFrom(attribute.getType());
    }

    private static boolean useTargetTable(AttributeAccessor attribute, AssociationOverride override) {
        JoinColumn joinColumn = override != null && override.joinColumns().length > 0 ? override.joinColumns()[0] : attribute.getAnnotation(JoinColumn.class);
        JoinTable joinTable = override != null && override.joinTable() != null ? override.joinTable() : attribute.getAnnotation(JoinTable.class);
        return joinColumn != null && joinTable == null;
    }

    public CollectionProperty(EntityClass<?> sourceClass, AttributeAccessor attribute, AssociationOverride override) {
        super(sourceClass.getContext(), attribute);
        this.orderColumn = CollectionProperty.buildOrderColumn(attribute);
        CollectionTable collectionTable = attribute.getAnnotation(CollectionTable.class);
        ElementCollection values = attribute.getAnnotation(ElementCollection.class);
        if (values != null) {
            this.mappedBy = null;
            this.useTargetTable = false;
            this.table = CollectionProperty.buildTableName(collectionTable, sourceClass.getEntityName() + '_' + attribute.getName());
            this.idColumn = CollectionProperty.buildIdColumn(attribute, override, collectionTable, sourceClass.getEntityName() + '_' + sourceClass.getIdColumn(attribute));
            this.targetClass = CollectionProperty.getPropertyArgument(attribute, values.targetClass(), 0);
            if (this.targetClass.isAnnotationPresent(Embeddable.class)) {
                this.buildEmbeddedProperties(this.targetClass);
                this.targetEntityClass = null;
                this.targetConverter = null;
                this.valueColumn = null;
            } else {
                this.targetEntityClass = sourceClass.getContext().getDescription(this.targetClass);
                this.targetConverter = this.targetEntityClass == null ? PrimitiveProperty.createConverter(attribute, this.targetClass, false) : null;
                this.valueColumn = CollectionProperty.buildValueColumn(attribute, attribute.getName());
            }
        } else {
            OneToMany oneToMany = attribute.getAnnotation(OneToMany.class);
            if (oneToMany == null) {
                ManyToMany manyToMany = attribute.getAnnotation(ManyToMany.class);
                Preconditions.checkArgument((manyToMany != null ? 1 : 0) != 0, (Object)(attribute + " is neither declared as OneToMany nor ManyToMany nor ElementCollection"));
                this.targetClass = CollectionProperty.getPropertyArgument(attribute, manyToMany.targetEntity(), 0);
                this.mappedBy = manyToMany.mappedBy().length() == 0 ? null : manyToMany.mappedBy();
                this.useTargetTable = this.mappedBy != null;
            } else {
                this.targetClass = CollectionProperty.getPropertyArgument(attribute, oneToMany.targetEntity(), 0);
                this.mappedBy = oneToMany.mappedBy().length() == 0 ? null : oneToMany.mappedBy();
                this.useTargetTable = this.mappedBy != null || CollectionProperty.useTargetTable(attribute, override);
            }
            this.targetEntityClass = sourceClass.getContext().getDescription(this.targetClass);
            Preconditions.checkArgument((this.targetEntityClass != null ? 1 : 0) != 0, (Object)("Collection accessor " + attribute + " needs an entity type"));
            this.targetConverter = null;
            if (this.mappedBy != null) {
                this.table = this.targetEntityClass.getTable();
                Property<T, ?> idProperty = this.targetEntityClass.getIdProperty();
                Preconditions.checkArgument((boolean)(idProperty instanceof SingularProperty), (Object)("Can only handle singular properties for ID in mapped by " + attribute));
                this.valueColumn = CollectionProperty.buildValueColumn(attribute, this.targetEntityClass.getIdColumn(attribute));
            } else if (this.useTargetTable) {
                this.table = this.targetEntityClass.getTable();
                this.idColumn = CollectionProperty.buildIdColumn(attribute, override, null, null, attribute.getName() + '_' + sourceClass.getIdColumn(attribute));
                this.valueColumn = CollectionProperty.buildValueColumn(attribute, this.targetEntityClass.getIdColumn(attribute));
            } else {
                JoinTable joinTable = attribute.getAnnotation(JoinTable.class);
                this.table = CollectionProperty.buildTableName(attribute, override, joinTable, collectionTable, sourceClass.getTable() + '_' + this.targetEntityClass.getTable());
                this.idColumn = CollectionProperty.buildIdColumn(attribute, override, joinTable, collectionTable, sourceClass.getEntityName() + '_' + sourceClass.getIdColumn(attribute));
                this.valueColumn = CollectionProperty.buildValueColumn(attribute, attribute.getName() + '_' + this.targetEntityClass.getIdColumn(attribute));
            }
        }
    }

    private EntityStatement createDirectPropertyStatement(E entity, String sourceId, int index, T value) {
        TableStatement stmt;
        String target;
        if (value == null) {
            target = "null";
        } else if (this.targetConverter != null) {
            target = this.targetConverter.getExpression(value, this.getContext());
        } else {
            target = this.targetEntityClass.getEntityReference(value, this.getMappedId(), this.useTargetTable);
            if (target == null) {
                this.targetEntityClass.markPendingUpdates(value, entity, this, index);
                return null;
            }
        }
        if (this.idColumn == null && this.mappedBy != null) {
            Property<T, ?> mappedByProperty = this.targetEntityClass.getProperties().get(this.mappedBy);
            Preconditions.checkArgument((mappedByProperty != null ? 1 : 0) != 0, (Object)("Could not find property: " + this.mappedBy + " in " + this.targetClass));
            Preconditions.checkArgument((boolean)(mappedByProperty instanceof SingularProperty), (Object)("Can only handle singular properties for mapped by in " + this.getAttribute().getElement()));
            this.idColumn = ((SingularProperty)mappedByProperty).getColumn();
        }
        if (this.useTargetTable) {
            if (value == null) {
                return null;
            }
            stmt = new UpdateStatement(this.table, this.valueColumn, target);
            if (this.mappedBy == null) {
                stmt.addValue(this.idColumn, sourceId);
            }
        } else {
            stmt = new InsertStatement(this.table);
            stmt.addValue(this.idColumn, sourceId);
            stmt.addValue(this.valueColumn, target);
        }
        if (this.orderColumn != null) {
            stmt.addValue(this.orderColumn, String.valueOf(index));
        }
        return stmt;
    }

    private InsertStatement createEmbeddedPropertiesStatement(String sourceId, int index, T value) {
        InsertStatement stmt = new InsertStatement(this.table);
        stmt.addValue(this.idColumn, sourceId);
        if (this.orderColumn != null) {
            stmt.addValue(this.orderColumn, String.valueOf(index));
        }
        for (SingularProperty property : this.getEmbeddedProperties()) {
            property.addInsertExpression(value, stmt);
        }
        return stmt;
    }

    @Override
    public List<EntityStatement> createPostInsertStatements(E entity) {
        if (this.mappedBy != null && this.orderColumn == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityStatement> result = new ArrayList<EntityStatement>();
        String sourceId = EntityConverter.getEntityReference(entity, this.getMappedId(), this.getContext(), false);
        int index = 0;
        Object collection = this.getValue((Object)entity);
        if (this.orderColumn == null && collection instanceof List && new HashSet(collection).size() < collection.size()) {
            throw new IllegalArgumentException("At least one duplicate value in " + this + " of " + entity + ": " + collection);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EntityStatement statement;
            Object value = iterator.next();
            if (this.isEmbedded()) {
                result.add(this.createEmbeddedPropertiesStatement(sourceId, index++, value));
                continue;
            }
            if ((statement = this.createDirectPropertyStatement(entity, sourceId, index++, value)) == null) continue;
            result.add(statement);
        }
        return result;
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        if (this.targetEntityClass != null) {
            return this.getValue((Object)entity);
        }
        if (this.isEmbedded()) {
            ArrayList result = new ArrayList();
            Iterator iterator = this.getValue((Object)entity).iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                for (Property property : this.getEmbeddedProperties()) {
                    result.addAll(property.findReferencedEntities(value));
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public List<EntityStatement> generatePendingStatements(E entity, Object writtenEntity, Object ... arguments) {
        String sourceId = EntityConverter.getEntityReference(entity, this.getMappedId(), this.getContext(), false);
        EntityStatement statement = this.createDirectPropertyStatement(entity, sourceId, (Integer)arguments[0], writtenEntity);
        return statement == null ? Collections.emptyList() : Collections.singletonList(statement);
    }

    @Override
    public Collection<T> getValue(E entity) {
        Collection value = (Collection)super.getValue(entity);
        return value == null ? Collections.emptySet() : value;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public EntityClass<T> getTargetEntityClass() {
        return this.targetEntityClass;
    }

    public ValueConverter<T> getTargetConverter() {
        return this.targetConverter;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getIdColumn() {
        return this.idColumn;
    }

    @Override
    public String getValueColumn() {
        return this.valueColumn;
    }

    public String getOrderColumn() {
        return this.orderColumn;
    }

    public boolean isUseTargetTable() {
        return this.useTargetTable;
    }
}

