/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.beans.ConstructorProperties;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.fastnate.generator.context.AccessStyle;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.CollectionProperty;
import org.fastnate.generator.context.EmbeddedProperty;
import org.fastnate.generator.context.EntityProperty;
import org.fastnate.generator.context.GeneratedIdProperty;
import org.fastnate.generator.context.GenerationState;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.MapProperty;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SequenceIdGenerator;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.context.UniquePropertyQuality;
import org.fastnate.generator.context.VersionProperty;
import org.fastnate.generator.statements.EntityStatement;

public class EntityClass<E> {
    private final GeneratorContext context;
    @NotNull
    private final Class<E> entityClass;
    @NotNull
    private final String entityName;
    @NotNull
    private String table;
    private AccessStyle accessStyle;
    private InheritanceType inheritanceType;
    private Class<? super E> parentEntityClass;
    private EntityClass<? super E> joinedParentClass;
    private EntityClass<? super E> hierarchyRoot;
    private String discriminator;
    private String discriminatorColumn;
    private String primaryKeyJoinColumn;
    @Nullable
    private Property<? super E, ?> idProperty;
    @Nullable
    private List<SingularProperty<E, ?>> uniqueProperties;
    private UniquePropertyQuality uniquePropertiesQuality;
    private final Map<String, Property<E, ?>> properties = new TreeMap();
    private final List<Property<? super E, ?>> allProperties = new ArrayList();
    private final Map<Object, GenerationState> entityStates;
    private final Map<String, AttributeOverride> attributeOverrides = new HashMap<String, AttributeOverride>();
    private final Map<String, AssociationOverride> associationOverrides = new HashMap<String, AssociationOverride>();

    static Map<String, AssociationOverride> getAccociationOverrides(AnnotatedElement fieldOrClass) {
        AssociationOverrides multiOverride = fieldOrClass.getAnnotation(AssociationOverrides.class);
        AssociationOverride singleOverride = fieldOrClass.getAnnotation(AssociationOverride.class);
        if (multiOverride == null && singleOverride == null) {
            return Collections.emptyMap();
        }
        ArrayList<AssociationOverride> config = new ArrayList<AssociationOverride>();
        if (multiOverride != null) {
            config.addAll(Arrays.asList(multiOverride.value()));
        }
        if (singleOverride != null) {
            config.add(singleOverride);
        }
        HashMap<String, AssociationOverride> attributeOverrides = new HashMap<String, AssociationOverride>();
        for (AssociationOverride override : config) {
            attributeOverrides.put(override.name(), override);
        }
        return attributeOverrides;
    }

    static Map<String, AttributeOverride> getAttributeOverrides(AnnotatedElement fieldOrClass) {
        AttributeOverrides multiOverride = fieldOrClass.getAnnotation(AttributeOverrides.class);
        AttributeOverride singleOverride = fieldOrClass.getAnnotation(AttributeOverride.class);
        if (multiOverride == null && singleOverride == null) {
            return Collections.emptyMap();
        }
        ArrayList<AttributeOverride> config = new ArrayList<AttributeOverride>();
        if (multiOverride != null) {
            config.addAll(Arrays.asList(multiOverride.value()));
        }
        if (singleOverride != null) {
            config.add(singleOverride);
        }
        HashMap<String, AttributeOverride> attributeOverrides = new HashMap<String, AttributeOverride>();
        for (AttributeOverride override : config) {
            attributeOverrides.put(override.name(), override);
        }
        return attributeOverrides;
    }

    EntityClass(GeneratorContext context, Class<E> entityClass) {
        this.context = context;
        this.entityClass = entityClass;
        String name = entityClass.getAnnotation(Entity.class).name();
        this.entityName = name.length() > 0 ? name : entityClass.getSimpleName();
        this.entityStates = context.getStates(this);
    }

    void build() {
        Table tableMetadata = this.entityClass.getAnnotation(Table.class);
        this.table = tableMetadata == null || tableMetadata.name().length() == 0 ? this.entityName : tableMetadata.name();
        this.buildOverrides(this.entityClass);
        this.buildGenerators(this.entityClass);
        this.buildInheritance();
        this.buildDiscriminator();
        if (this.joinedParentClass == null) {
            this.buildIdProperty(this.entityClass);
            ModelException.test(this.idProperty != null, "No id found for {}", this.entityClass);
            this.allProperties.add(this.idProperty);
            this.buildProperties(this.entityClass, Object.class);
        } else {
            this.idProperty = this.joinedParentClass.getIdProperty();
            this.allProperties.add(this.idProperty);
            this.buildProperties(this.entityClass, this.joinedParentClass.entityClass);
        }
        if (tableMetadata != null && this.uniqueProperties == null) {
            this.buildUniqueProperties(tableMetadata.uniqueConstraints());
        }
    }

    private void buildDiscriminator() {
        DiscriminatorColumn column;
        if (!(this.inheritanceType != InheritanceType.SINGLE_TABLE && this.inheritanceType != InheritanceType.JOINED || (column = this.hierarchyRoot.entityClass.getAnnotation(DiscriminatorColumn.class)) == null && this.inheritanceType == InheritanceType.JOINED && !this.context.getProvider().isJoinedDiscriminatorNeeded())) {
            this.discriminatorColumn = column == null ? "DTYPE" : column.name();
            this.discriminator = this.buildDiscriminator(this, column);
        }
    }

    private String buildDiscriminator(EntityClass<?> c, DiscriminatorColumn column) {
        String v;
        int maxLength;
        DiscriminatorType type;
        if (column == null) {
            type = DiscriminatorType.STRING;
            int defaultMaxLength = 31;
            maxLength = 31;
        } else {
            type = column.discriminatorType();
            maxLength = column.length();
        }
        DiscriminatorValue value = this.entityClass.getAnnotation(DiscriminatorValue.class);
        if (type == DiscriminatorType.INTEGER) {
            return value == null ? String.valueOf(c.getEntityName().hashCode()) : value.value();
        }
        String string = v = value == null ? c.getEntityName() : value.value();
        if (StringUtils.isEmpty((String)v)) {
            throw new IllegalArgumentException("Missing discriminator value for: " + c.getEntityClass());
        }
        if (type == DiscriminatorType.STRING) {
            return this.getContext().getDialect().quoteString(v.length() <= maxLength ? v : v.substring(0, maxLength));
        }
        if (type == DiscriminatorType.CHAR) {
            return this.getContext().getDialect().quoteString(v.substring(0, 1));
        }
        throw new IllegalArgumentException("Unknown discriminator type: " + type);
    }

    private void buildGenerators(Class<?> c) {
        if (c.getSuperclass() != null) {
            this.buildGenerators(c.getSuperclass());
        }
        this.context.registerGenerators(c, this.table);
    }

    private void buildIdProperty(Class<? super E> c) {
        if (c.getSuperclass() != null) {
            this.buildIdProperty(c.getSuperclass());
        }
        if (c.isAnnotationPresent(Entity.class) || c.isAnnotationPresent(MappedSuperclass.class)) {
            Access accessType;
            if (this.accessStyle == null && (accessType = c.getAnnotation(Access.class)) != null) {
                this.accessStyle = AccessStyle.getStyle(accessType.value());
            }
            if (this.accessStyle == null) {
                if (this.findIdProperty(AccessStyle.FIELD.getDeclaredAttributes(c))) {
                    this.accessStyle = AccessStyle.FIELD;
                } else if (this.findIdProperty(AccessStyle.METHOD.getDeclaredAttributes(c))) {
                    this.accessStyle = AccessStyle.METHOD;
                }
            } else {
                this.findIdProperty(this.accessStyle.getDeclaredAttributes(c));
            }
        }
    }

    private void buildInheritance() {
        Inheritance inheritance = this.entityClass.getAnnotation(Inheritance.class);
        if (inheritance != null) {
            this.inheritanceType = inheritance.strategy();
        }
        this.hierarchyRoot = this;
        this.findHierarchyRoot(this.entityClass.getSuperclass());
        if (this.inheritanceType == null && this.entityClass.isAnnotationPresent(DiscriminatorColumn.class) || this.entityClass.isAnnotationPresent(DiscriminatorValue.class)) {
            this.inheritanceType = InheritanceType.SINGLE_TABLE;
        }
        this.buildDiscriminator();
    }

    private void buildOverrides(Class<? super E> inspectedClass) {
        if (inspectedClass.getSuperclass() != null) {
            this.buildOverrides(inspectedClass.getSuperclass());
        }
        this.attributeOverrides.putAll(EntityClass.getAttributeOverrides(inspectedClass));
        this.associationOverrides.putAll(EntityClass.getAccociationOverrides(inspectedClass));
    }

    private void buildPrimaryKeyJoinColumn() {
        if (this.joinedParentClass.getIdProperty() instanceof SingularProperty) {
            PrimaryKeyJoinColumn pkColumn = this.entityClass.getAnnotation(PrimaryKeyJoinColumn.class);
            this.primaryKeyJoinColumn = pkColumn == null || StringUtils.isEmpty((String)pkColumn.name()) ? ((SingularProperty)this.joinedParentClass.getIdProperty()).getColumn() : pkColumn.name();
        } else {
            throw new IllegalArgumentException("JOINED inheritance strategy is currently only supported with singular ID properties.");
        }
    }

    private void buildProperties(Class<?> c, Class<?> stopClass) {
        if (c.getSuperclass() != null && c.getSuperclass() != stopClass) {
            this.buildProperties(c.getSuperclass(), stopClass);
        }
        if (c.isAnnotationPresent(MappedSuperclass.class) || c.isAnnotationPresent(Entity.class)) {
            for (AttributeAccessor field : this.accessStyle.getDeclaredAttributes(c)) {
                Property property;
                if (field.isAnnotationPresent(EmbeddedId.class) || field.isAnnotationPresent(Id.class) || (property = this.buildProperty(field, this.getColumnAnnotation(field), this.associationOverrides.get(field.getName()))) == null) continue;
                this.properties.put(field.getName(), property);
                this.allProperties.add(property);
                if (!(property instanceof SingularProperty)) continue;
                this.buildUniqueProperty((SingularProperty)property);
            }
        }
    }

    <X> Property<X, ?> buildProperty(AttributeAccessor attribute, Column columnMetadata, AssociationOverride override) {
        if (attribute.isPersistent()) {
            if (CollectionProperty.isCollectionProperty(attribute)) {
                return new CollectionProperty(this, attribute, override);
            }
            if (MapProperty.isMapProperty(attribute)) {
                return new MapProperty(this, attribute, override);
            }
            if (EntityProperty.isEntityProperty(attribute)) {
                return new EntityProperty(this.context, attribute, override);
            }
            if (attribute.isAnnotationPresent(Embedded.class)) {
                return new EmbeddedProperty(this, attribute);
            }
            if (attribute.isAnnotationPresent(Version.class)) {
                return new VersionProperty(this.context, this.table, attribute, columnMetadata);
            }
            return new PrimitiveProperty(this.context, this.table, attribute, columnMetadata);
        }
        return null;
    }

    private void buildUniqueProperties(UniqueConstraint[] uniqueConstraints) {
        for (UniqueConstraint constraint : uniqueConstraints) {
            if (constraint.columnNames().length > this.context.getMaxUniqueProperties()) continue;
            this.instpectUniqueConstraint(constraint);
        }
    }

    private void buildUniqueProperty(SingularProperty<E, ?> property) {
        UniquePropertyQuality propertyQuality;
        Column column;
        if (this.context.getMaxUniqueProperties() > 0 && (column = property.getAttribute().getAnnotation(Column.class)) != null && column.unique() && (propertyQuality = UniquePropertyQuality.getMatchingQuality(property)) != null && this.isBetterUniquePropertyQuality(propertyQuality)) {
            this.uniquePropertiesQuality = propertyQuality;
            this.uniqueProperties = Collections.singletonList(property);
        }
    }

    public List<EntityStatement> createPostInsertStatements(E entity) {
        if (this.joinedParentClass == null) {
            GenerationState oldState;
            if (this.idProperty instanceof GeneratedIdProperty) {
                GeneratedIdProperty generatedIdProperty = (GeneratedIdProperty)this.idProperty;
                generatedIdProperty.postInsert(entity);
                oldState = generatedIdProperty.isPrimitive() && ((Number)generatedIdProperty.getValue(entity)).longValue() == 0L ? this.entityStates.put(new EntityId(entity), GenerationState.PERSISTED) : this.entityStates.remove(new EntityId(entity));
            } else {
                oldState = this.entityStates.put(this.getStateId(entity), GenerationState.PERSISTED);
            }
            if (oldState instanceof GenerationState.PendingState) {
                return ((GenerationState.PendingState)oldState).generatePendingStatements(entity);
            }
        }
        return Collections.emptyList();
    }

    private void findHierarchyRoot(Class<? super E> inspectedClass) {
        if (inspectedClass != null) {
            if (!inspectedClass.isAnnotationPresent(Entity.class)) {
                this.findHierarchyRoot(inspectedClass.getSuperclass());
            } else {
                this.parentEntityClass = inspectedClass;
                EntityClass<Class<E>> parentDescription = this.context.getDescription(inspectedClass);
                this.accessStyle = parentDescription.getAccessStyle();
                if (parentDescription.inheritanceType == null) {
                    parentDescription.inheritanceType = InheritanceType.SINGLE_TABLE;
                    super.buildDiscriminator();
                }
                if (this.inheritanceType == null) {
                    this.inheritanceType = parentDescription.inheritanceType;
                    this.hierarchyRoot = parentDescription.hierarchyRoot;
                } else if (parentDescription.inheritanceType != InheritanceType.TABLE_PER_CLASS) {
                    this.hierarchyRoot = parentDescription.hierarchyRoot;
                }
                if (parentDescription.getInheritanceType() == InheritanceType.JOINED) {
                    this.joinedParentClass = parentDescription;
                    this.buildPrimaryKeyJoinColumn();
                } else {
                    if (parentDescription.getInheritanceType() == InheritanceType.SINGLE_TABLE) {
                        this.table = parentDescription.table;
                    }
                    this.joinedParentClass = parentDescription.joinedParentClass;
                    this.primaryKeyJoinColumn = parentDescription.primaryKeyJoinColumn;
                }
            }
        }
    }

    private boolean findIdProperty(Iterable<AttributeAccessor> declaredAttributes) {
        for (AttributeAccessor attribute : declaredAttributes) {
            if (attribute.isAnnotationPresent(EmbeddedId.class)) {
                this.idProperty = new EmbeddedProperty(this, attribute);
                return true;
            }
            if (!attribute.isAnnotationPresent(Id.class)) continue;
            if (attribute.isAnnotationPresent(GeneratedValue.class)) {
                this.context.registerGenerators(attribute, this.table);
                this.idProperty = new GeneratedIdProperty<E>(this, attribute, this.getColumnAnnotation(attribute));
            } else {
                this.idProperty = this.buildProperty(attribute, this.getColumnAnnotation(attribute), this.associationOverrides.get(attribute.getName()));
            }
            return true;
        }
        return false;
    }

    private Column getColumnAnnotation(AttributeAccessor attribute) {
        AttributeOverride override = this.attributeOverrides.get(attribute.getName());
        return override != null ? override.column() : attribute.getAnnotation(Column.class);
    }

    public String getEntityReference(E entity, String idField, boolean whereExpression) {
        String expression;
        if (this.joinedParentClass != null) {
            return this.joinedParentClass.getEntityReference(entity, idField, whereExpression);
        }
        Property<Object, ?> property = this.idProperty;
        if (property instanceof GeneratedIdProperty) {
            if (this.context.isWriteRelativeIds()) {
                return this.getGeneratedIdReference(entity, whereExpression);
            }
            return property.getExpression(entity, whereExpression);
        }
        if (property instanceof EmbeddedProperty) {
            Map embeddedProperties = ((EmbeddedProperty)this.idProperty).getEmbeddedProperties();
            if (idField == null) {
                ModelException.test(embeddedProperties.size() != 1, "Missing MapsId annotation for access to {}", this.idProperty);
                property = embeddedProperties.values().iterator().next();
            } else {
                property = embeddedProperties.get(idField);
                ModelException.test(property != null, "MapsId reference {} not found in {}", idField, this.idProperty);
            }
        }
        ModelException.test((expression = property.getExpression(entity, whereExpression)) != null, "Can't find any id for {} in property '{}'", this.idProperty, entity);
        return expression;
    }

    private String getGeneratedIdReference(E entity, boolean whereExpression) {
        GeneratedIdProperty generatedIdProperty = (GeneratedIdProperty)this.idProperty;
        if (!generatedIdProperty.isReference(entity) && this.uniqueProperties != null) {
            IdGenerator generator;
            if (this.context.isPreferSequenceCurentValue() && (generator = generatedIdProperty.getGenerator()) instanceof SequenceIdGenerator && generator.getCurrentValue() == ((Number)generatedIdProperty.getValue(entity)).longValue()) {
                return generatedIdProperty.getExpression(entity, whereExpression);
            }
            StringBuilder condition = new StringBuilder();
            for (SingularProperty<E, ?> property : this.uniqueProperties) {
                String expression = property.getPredicate(entity);
                if (expression == null) {
                    return generatedIdProperty.getExpression(entity, whereExpression);
                }
                if (condition.length() > 0) {
                    condition.append(" AND ");
                }
                condition.append(expression);
            }
            if (this.discriminator != null) {
                condition.append(" AND ").append(this.discriminatorColumn).append(" = ").append(this.discriminator);
            }
            return "(SELECT " + generatedIdProperty.getColumn() + " FROM " + this.table + " WHERE " + condition + ')';
        }
        return generatedIdProperty.getExpression(entity, whereExpression);
    }

    String getIdColumn(AttributeAccessor attribute) {
        if (this.idProperty instanceof SingularProperty) {
            return ((SingularProperty)this.idProperty).getColumn();
        }
        if (this.idProperty instanceof EmbeddedProperty) {
            Property property;
            MapsId mapsId = attribute.getAnnotation(MapsId.class);
            if (mapsId != null && mapsId.value().length() > 0 && (property = ((EmbeddedProperty)this.idProperty).getEmbeddedProperties().get(mapsId.value())) instanceof SingularProperty) {
                return ((SingularProperty)this.idProperty).getColumn();
            }
            throw new ModelException(attribute + " misses MapId for a singular property in " + this.entityClass);
        }
        if (this.idProperty == null && this.parentEntityClass != null) {
            this.idProperty = this.context.getDescription(this.parentEntityClass).getIdProperty();
            if (this.idProperty != null) {
                return this.getIdColumn(attribute);
            }
        }
        throw new ModelException(attribute + " does not reference an ID column in " + this.entityClass);
    }

    private Object getStateId(E entity) {
        if (this.idProperty instanceof GeneratedIdProperty) {
            return new EntityId(entity);
        }
        Object id = this.idProperty.getValue(entity);
        if (id == null) {
            throw new IllegalArgumentException("Missing id for entity of type " + this.entityClass + ": " + entity);
        }
        return id;
    }

    private void instpectUniqueConstraint(UniqueConstraint constraint) {
        String[] columnNames;
        UniquePropertyQuality currentQuality = UniquePropertyQuality.onlyRequiredPrimitives;
        ArrayList uniques = new ArrayList();
        for (String columnName : columnNames = constraint.columnNames()) {
            for (Property<E, ?> property : this.properties.values()) {
                UniquePropertyQuality quality;
                SingularProperty singularProperty;
                if (!(property instanceof SingularProperty) || !columnName.equals((singularProperty = (SingularProperty)property).getColumn()) || (quality = UniquePropertyQuality.getMatchingQuality(property)) == null) continue;
                if (quality.ordinal() > currentQuality.ordinal()) {
                    currentQuality = quality;
                }
                uniques.add(singularProperty);
            }
        }
        if (uniques.size() == columnNames.length && this.isBetterUniquePropertyQuality(currentQuality)) {
            this.uniqueProperties = uniques;
            this.uniquePropertiesQuality = currentQuality;
        }
    }

    private boolean isBetterUniquePropertyQuality(UniquePropertyQuality foundQuality) {
        return (this.uniquePropertiesQuality == null || this.uniquePropertiesQuality.ordinal() > foundQuality.ordinal()) && foundQuality.ordinal() <= this.context.getUniquePropertyQuality().ordinal();
    }

    public boolean isNew(E entity) {
        if (this.idProperty instanceof GeneratedIdProperty) {
            GeneratedIdProperty generatedIdProperty = (GeneratedIdProperty)this.idProperty;
            if (!generatedIdProperty.isNew(entity)) {
                return false;
            }
            if (!generatedIdProperty.isPrimitive()) {
                return true;
            }
        }
        return this.entityStates.get(this.getStateId(entity)) != GenerationState.PERSISTED;
    }

    public void markExistingEntity(E entity) {
        if (this.idProperty instanceof GeneratedIdProperty) {
            ((GeneratedIdProperty)this.idProperty).markReference(entity);
            this.entityStates.remove(new EntityId(entity));
        } else {
            this.entityStates.put(this.getStateId(entity), GenerationState.PERSISTED);
        }
    }

    public <V> void markPendingUpdates(E pendingEntity, V entityToUpdate, Property<V, ?> propertyToUpdate, Object ... arguments) {
        GenerationState.PendingState pendingState;
        Object id = this.getStateId(pendingEntity);
        GenerationState state = this.entityStates.get(id);
        if (state instanceof GenerationState.PendingState) {
            pendingState = (GenerationState.PendingState)state;
        } else {
            pendingState = new GenerationState.PendingState();
            this.entityStates.put(id, pendingState);
        }
        pendingState.addPendingUpdate(entityToUpdate, propertyToUpdate, arguments);
    }

    public String toString() {
        return this.entityClass.getName();
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTable() {
        return this.table;
    }

    public AccessStyle getAccessStyle() {
        return this.accessStyle;
    }

    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    public Class<? super E> getParentEntityClass() {
        return this.parentEntityClass;
    }

    public EntityClass<? super E> getJoinedParentClass() {
        return this.joinedParentClass;
    }

    public EntityClass<? super E> getHierarchyRoot() {
        return this.hierarchyRoot;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public String getPrimaryKeyJoinColumn() {
        return this.primaryKeyJoinColumn;
    }

    @Nullable
    public Property<? super E, ?> getIdProperty() {
        return this.idProperty;
    }

    @Nullable
    public List<SingularProperty<E, ?>> getUniqueProperties() {
        return this.uniqueProperties;
    }

    public UniquePropertyQuality getUniquePropertiesQuality() {
        return this.uniquePropertiesQuality;
    }

    public Map<String, Property<E, ?>> getProperties() {
        return this.properties;
    }

    public List<Property<? super E, ?>> getAllProperties() {
        return this.allProperties;
    }

    public Map<Object, GenerationState> getEntityStates() {
        return this.entityStates;
    }

    public Map<String, AttributeOverride> getAttributeOverrides() {
        return this.attributeOverrides;
    }

    public Map<String, AssociationOverride> getAssociationOverrides() {
        return this.associationOverrides;
    }

    private static final class EntityId {
        private final Object entity;

        public boolean equals(Object obj) {
            return obj instanceof EntityId && ((EntityId)obj).entity == this.entity;
        }

        public int hashCode() {
            return 0;
        }

        @ConstructorProperties(value={"entity"})
        public EntityId(Object entity) {
            this.entity = entity;
        }
    }
}

