/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.AssociationOverride;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.validation.constraints.NotNull;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;
import org.fastnate.generator.statements.UpdateStatement;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MetaValue;

public class EntityProperty<E, T>
extends SingularProperty<E, T> {
    private final GeneratorContext context;
    private final boolean required;
    private final String mappedBy;
    private final String column;
    private final String idField;
    private final String anyColumn;
    private final Map<Class<?>, String> anyClasses = new HashMap();

    static boolean isEntityProperty(AttributeAccessor attribute) {
        return attribute.isAnnotationPresent(OneToOne.class) || attribute.isAnnotationPresent(ManyToOne.class) || attribute.isAnnotationPresent(Any.class) || attribute.isAnnotationPresent(ManyToAny.class);
    }

    public EntityProperty(GeneratorContext context, AttributeAccessor attribute, @Nullable AssociationOverride override) {
        super(attribute);
        this.context = context;
        EntityClass<Class<?>> targetClass = context.getDescription(attribute.getType());
        MappingInformation mapping = new MappingInformation(attribute);
        this.required = !mapping.isOptional();
        this.mappedBy = mapping.getMappedBy().length() == 0 ? null : mapping.getMappedBy();
        MapsId mapsId = attribute.getAnnotation(MapsId.class);
        String string = this.idField = mapsId != null ? mapsId.value() : null;
        if (this.mappedBy == null) {
            JoinColumn joinColumn;
            JoinColumn joinColumn2 = joinColumn = override != null && override.joinColumns().length > 0 ? override.joinColumns()[0] : attribute.getAnnotation(JoinColumn.class);
            this.column = joinColumn != null && joinColumn.name().length() > 0 ? joinColumn.name() : attribute.getName() + "_" + (targetClass == null ? "id" : targetClass.getIdColumn(attribute));
        } else {
            this.column = null;
        }
        this.anyColumn = mapping.getAnyMetaColumn();
        if (this.anyColumn != null) {
            this.fillMetaDefs(attribute);
        }
    }

    @Override
    public void addInsertExpression(E entity, InsertStatement statement) {
        if (this.column != null) {
            Object value = this.getValue(entity);
            if (value != null) {
                EntityClass entityClass = this.context.getDescription(value);
                String expression = entityClass.getEntityReference(value, this.idField, false);
                if (expression != null) {
                    statement.addValue(this.column, expression);
                    if (this.anyColumn != null) {
                        statement.addValue(this.anyColumn, this.findAnyDesc(value));
                    }
                    return;
                }
                entityClass.markPendingUpdates(value, entity, this, new Object[0]);
            }
            this.failIfRequired();
            if (this.context.isWriteNullValues()) {
                statement.addValue(this.column, "null");
                if (this.anyColumn != null) {
                    statement.addValue(this.anyColumn, "null");
                }
            }
        }
    }

    private void fillMetaDefs(AttributeAccessor attribute) {
        AnyMetaDef metaDef = attribute.getAnnotation(AnyMetaDef.class);
        if (metaDef == null) {
            throw new IllegalArgumentException("Missing AnyMetaDef for " + attribute);
        }
        for (MetaValue metaValue : metaDef.metaValues()) {
            this.anyClasses.put(metaValue.targetEntity(), "'" + metaValue.value() + "'");
        }
    }

    private String findAnyDesc(T entity) {
        String desc = this.anyClasses.get(entity.getClass());
        if (desc == null) {
            throw new IllegalArgumentException("Can'f find meta description for " + entity.getClass() + " on " + this.getAttribute());
        }
        return desc;
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        Object value = this.getValue(entity);
        return value == null ? Collections.emptySet() : Collections.singleton(value);
    }

    @Override
    public List<EntityStatement> generatePendingStatements(E entity, Object writtenEntity, Object ... arguments) {
        String expression = this.context.getDescription(writtenEntity).getEntityReference(writtenEntity, this.idField, false);
        if (expression == null) {
            throw new ModelException("Entity can't be referenced: " + writtenEntity);
        }
        EntityClass<E> entityClass = this.context.getDescription(entity);
        UpdateStatement stmt = new UpdateStatement(entityClass.getTable(), entityClass.getIdColumn(this.getAttribute()), entityClass.getEntityReference(entity, this.idField, true));
        stmt.addValue(this.column, expression);
        return Collections.singletonList(stmt);
    }

    @Override
    public String getExpression(E entity, boolean whereExpression) {
        Object value = this.getValue(entity);
        if (value == null) {
            return "null";
        }
        return EntityConverter.getEntityReference(value, this.idField, this.context, whereExpression);
    }

    @Override
    public String getPredicate(E entity) {
        Object value = this.getValue(entity);
        if (value == null) {
            return this.column + " IS NULL";
        }
        String reference = EntityConverter.getEntityReference(value, this.idField, this.context, true);
        if (reference == null) {
            return null;
        }
        if (this.anyColumn != null) {
            return '(' + this.column + " = " + reference + " AND " + this.anyColumn + " = " + this.findAnyDesc(value) + ')';
        }
        return this.column + " = " + reference;
    }

    @Override
    public boolean isTableColumn() {
        return this.mappedBy == null;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getAnyColumn() {
        return this.anyColumn;
    }

    public Map<Class<?>, String> getAnyClasses() {
        return this.anyClasses;
    }

    private static class MappingInformation {
        private final boolean optional;
        private final String mappedBy;
        private final String anyMetaColumn;

        MappingInformation(AttributeAccessor attribute) {
            OneToOne oneToOne = attribute.getAnnotation(OneToOne.class);
            NotNull notNull = attribute.getAnnotation(NotNull.class);
            if (oneToOne != null) {
                this.optional = oneToOne.optional() && notNull == null;
                this.mappedBy = oneToOne.mappedBy();
                this.anyMetaColumn = null;
            } else {
                this.mappedBy = "";
                ManyToOne manyToOne = attribute.getAnnotation(ManyToOne.class);
                if (manyToOne != null) {
                    this.optional = manyToOne.optional() && notNull == null;
                    this.anyMetaColumn = null;
                } else {
                    Any any = attribute.getAnnotation(Any.class);
                    if (any != null) {
                        this.optional = any.optional() && notNull == null;
                        this.anyMetaColumn = any.metaColumn().name();
                    } else {
                        ManyToAny manyToAny = attribute.getAnnotation(ManyToAny.class);
                        if (manyToAny == null) {
                            throw new IllegalArgumentException(attribute + " is neither declared as OneToOne nor ManyToOne");
                        }
                        this.optional = notNull == null;
                        this.anyMetaColumn = manyToAny.metaColumn().name();
                    }
                }
            }
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getMappedBy() {
            return this.mappedBy;
        }

        public String getAnyMetaColumn() {
            return this.anyMetaColumn;
        }
    }
}

