/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.statements.EntityStatement;

public class GenerationState {
    public static final GenerationState PERSISTED = new GenerationState();

    private GenerationState() {
    }

    public static final class PendingState
    extends GenerationState {
        private final List<Update<?>> updates = new ArrayList();

        public <E> void addPendingUpdate(E entity, Property<E, ?> property, Object ... arguments) {
            this.updates.add(new Update<E>(entity, property, arguments));
        }

        public <E> List<EntityStatement> generatePendingStatements(Object entity) {
            ArrayList<EntityStatement> result = new ArrayList<EntityStatement>();
            Iterator<Update<?>> iterator = this.updates.iterator();
            while (iterator.hasNext()) {
                Update<?> update;
                Update<?> singleUpdate = update = iterator.next();
                result.addAll(singleUpdate.getProperty().generatePendingStatements(singleUpdate.getEntity(), entity, singleUpdate.getArguments()));
            }
            return result;
        }

        public List<Update<?>> getUpdates() {
            return this.updates;
        }

        private static final class Update<E> {
            private final E entity;
            private final Property<E, ?> property;
            private final Object[] arguments;

            public E getEntity() {
                return this.entity;
            }

            public Property<E, ?> getProperty() {
                return this.property;
            }

            public Object[] getArguments() {
                return this.arguments;
            }

            @ConstructorProperties(value={"entity", "property", "arguments"})
            public Update(E entity, Property<E, ?> property, Object[] arguments) {
                this.entity = entity;
                this.property = property;
                this.arguments = arguments;
            }
        }
    }
}

