/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;

public class IdentityValue
extends IdGenerator {
    private final GeneratorContext context;
    private final String tableName;
    private final String columnName;
    private long currentValue;
    private boolean needsAlignment;

    @Override
    public void addNextValue(InsertStatement statement, String column, Number value) {
    }

    @Override
    public List<? extends EntityStatement> alignNextValue() {
        if (this.needsAlignment) {
            this.needsAlignment = false;
            if (!this.context.isWriteRelativeIds() && this.context.getDialect().isSettingIdentityAllowed()) {
                return this.context.getDialect().adjustNextIdentityValue(this.tableName, this.columnName, this.currentValue + 1L);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public long createNextValue() {
        this.needsAlignment = true;
        return ++this.currentValue;
    }

    public List<EntityStatement> createPreInsertStatements() {
        return Collections.emptyList();
    }

    @Override
    public String getExpression(String table, String column, Number targetId, boolean whereExpression) {
        long diff = this.currentValue - targetId.longValue();
        return "(SELECT max(" + this.columnName + ")" + (diff == 0L ? "" : " - " + diff) + " FROM " + this.tableName + ")";
    }

    @Override
    public boolean isPostIncrement() {
        return true;
    }

    @Override
    public void setCurrentValue(long currentValue) {
        this.needsAlignment = false;
        this.currentValue = currentValue;
    }

    @ConstructorProperties(value={"context", "tableName", "columnName"})
    public IdentityValue(GeneratorContext context, String tableName, String columnName) {
        this.context = context;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    @Override
    public long getCurrentValue() {
        return this.currentValue;
    }
}

