/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.OneToMany;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.PluralProperty;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;

public class MapProperty<E, K, T>
extends PluralProperty<E, Map<K, T>, T> {
    private final String mappedBy;
    private final Class<K> keyClass;
    private final EntityClass<K> keyEntityClass;
    private final ValueConverter<K> keyConverter;
    private final Class<T> valueClass;
    private final EntityClass<T> valueEntityClass;
    private final ValueConverter<T> valueConverter;
    private final String table;
    private final String idColumn;
    private final String keyColumn;
    private final String valueColumn;

    private static String buildKeyColumn(MapKeyColumn keyColumn, String defaultKeyColumn) {
        if (keyColumn != null && keyColumn.name().length() > 0) {
            return keyColumn.name();
        }
        return defaultKeyColumn;
    }

    private static String buildKeyColumn(MapKeyJoinColumn keyColumn, String defaultKeyColumn) {
        if (keyColumn != null && keyColumn.name().length() > 0) {
            return keyColumn.name();
        }
        return defaultKeyColumn;
    }

    static boolean isMapProperty(AttributeAccessor attribute) {
        return (attribute.isAnnotationPresent(OneToMany.class) || attribute.isAnnotationPresent(ManyToMany.class) || attribute.isAnnotationPresent(ElementCollection.class)) && Map.class.isAssignableFrom(attribute.getType());
    }

    public MapProperty(EntityClass<?> sourceClass, AttributeAccessor attribute, AssociationOverride override) {
        super(sourceClass.getContext(), attribute);
        MapKeyClass keyClassAnnotation = attribute.getAnnotation(MapKeyClass.class);
        this.keyClass = MapProperty.getPropertyArgument(attribute, keyClassAnnotation != null ? keyClassAnnotation.value() : Void.TYPE, 0);
        this.keyEntityClass = sourceClass.getContext().getDescription(this.keyClass);
        if (this.keyEntityClass != null) {
            this.keyConverter = null;
            this.keyColumn = MapProperty.buildKeyColumn(attribute.getAnnotation(MapKeyJoinColumn.class), attribute.getName() + "_KEY");
        } else {
            this.keyConverter = PrimitiveProperty.createConverter(attribute, this.keyClass, true);
            this.keyColumn = MapProperty.buildKeyColumn(attribute.getAnnotation(MapKeyColumn.class), attribute.getName() + "_KEY");
        }
        ElementCollection values = attribute.getAnnotation(ElementCollection.class);
        if (values != null) {
            this.mappedBy = null;
            CollectionTable collectionTable = attribute.getAnnotation(CollectionTable.class);
            this.table = MapProperty.buildTableName(collectionTable, sourceClass.getEntityName() + '_' + attribute.getName());
            this.idColumn = MapProperty.buildIdColumn(attribute, override, collectionTable, sourceClass.getEntityName() + '_' + sourceClass.getIdColumn(attribute));
            this.valueClass = MapProperty.getPropertyArgument(attribute, values.targetClass(), 1);
            if (this.valueClass.isAnnotationPresent(Embeddable.class)) {
                this.buildEmbeddedProperties(this.valueClass);
                this.valueEntityClass = null;
                this.valueConverter = null;
                this.valueColumn = null;
            } else {
                this.valueEntityClass = sourceClass.getContext().getDescription(this.valueClass);
                this.valueConverter = this.valueEntityClass == null ? PrimitiveProperty.createConverter(attribute, this.valueClass, false) : null;
                this.valueColumn = MapProperty.buildValueColumn(attribute, attribute.getName());
            }
        } else {
            OneToMany oneToMany = attribute.getAnnotation(OneToMany.class);
            if (oneToMany == null) {
                ManyToMany manyToMany = attribute.getAnnotation(ManyToMany.class);
                Preconditions.checkArgument((manyToMany != null ? 1 : 0) != 0, (Object)(attribute + " is neither declared as OneToMany nor ManyToMany nor ElementCollection"));
                this.valueClass = MapProperty.getPropertyArgument(attribute, manyToMany.targetEntity(), 1);
                this.mappedBy = manyToMany.mappedBy().length() == 0 ? null : manyToMany.mappedBy();
            } else {
                this.valueClass = MapProperty.getPropertyArgument(attribute, oneToMany.targetEntity(), 1);
                this.mappedBy = oneToMany.mappedBy().length() == 0 ? null : oneToMany.mappedBy();
            }
            this.valueEntityClass = sourceClass.getContext().getDescription(this.valueClass);
            Preconditions.checkArgument((this.valueClass != null ? 1 : 0) != 0, (Object)("Map field " + attribute + " needs an entity as value"));
            this.valueConverter = null;
            if (this.mappedBy != null) {
                this.table = null;
                this.idColumn = null;
                this.valueColumn = null;
            } else {
                JoinTable joinTable = attribute.getAnnotation(JoinTable.class);
                CollectionTable collectionTable = attribute.getAnnotation(CollectionTable.class);
                this.table = MapProperty.buildTableName(attribute, override, joinTable, collectionTable, sourceClass.getTable() + '_' + this.valueEntityClass.getTable());
                this.idColumn = MapProperty.buildIdColumn(attribute, override, joinTable, collectionTable, sourceClass.getEntityName() + '_' + sourceClass.getIdColumn(attribute));
                this.valueColumn = MapProperty.buildValueColumn(attribute, attribute.getName() + '_' + this.valueEntityClass.getIdColumn(attribute));
            }
        }
    }

    @Override
    public List<EntityStatement> createPostInsertStatements(E entity) {
        if (this.mappedBy != null) {
            return Collections.emptyList();
        }
        ArrayList<EntityStatement> result = new ArrayList<EntityStatement>();
        String sourceId = EntityConverter.getEntityReference(entity, this.getMappedId(), this.getContext(), false);
        for (Map.Entry entry : this.getValue((Object)entity).entrySet()) {
            String key = entry.getKey() == null ? "null" : (this.keyEntityClass != null ? EntityConverter.getEntityReference(entry.getKey(), this.getMappedId(), this.getContext(), false) : this.keyConverter.getExpression(entry.getKey(), this.getContext()));
            if (this.isEmbedded()) {
                result.add(this.createEmbeddedPropertiesStatement(sourceId, key, entry.getValue()));
                continue;
            }
            EntityStatement statement = this.createDirectPropertyStatement(entity, sourceId, key, entry.getValue());
            if (statement == null) continue;
            result.add(statement);
        }
        return result;
    }

    private EntityStatement createDirectPropertyStatement(E entity, String sourceId, String key, T value) {
        String target;
        if (value == null) {
            target = "null";
        } else if (this.valueConverter != null) {
            target = this.valueConverter.getExpression(value, this.getContext());
        } else {
            target = this.valueEntityClass.getEntityReference(value, this.getMappedId(), false);
            if (target == null) {
                this.valueEntityClass.markPendingUpdates(value, entity, this, key);
                return null;
            }
        }
        InsertStatement stmt = new InsertStatement(this.table);
        stmt.addValue(this.idColumn, sourceId);
        stmt.addValue(this.keyColumn, key);
        stmt.addValue(this.valueColumn, target);
        return stmt;
    }

    private InsertStatement createEmbeddedPropertiesStatement(String sourceId, String key, T value) {
        InsertStatement stmt = new InsertStatement(this.table);
        stmt.addValue(this.idColumn, sourceId);
        stmt.addValue(this.keyColumn, key);
        for (SingularProperty property : this.getEmbeddedProperties()) {
            property.addInsertExpression(value, stmt);
        }
        return stmt;
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        ArrayList<Object> entities;
        Collection<Object> keyEntities = Collections.emptyList();
        Collection<Object> valueEntities = Collections.emptyList();
        if (this.keyEntityClass != null) {
            keyEntities = this.getValue((Object)entity).keySet();
        }
        if (this.valueEntityClass != null) {
            valueEntities = this.getValue((Object)entity).values();
        } else if (this.isEmbedded()) {
            entities = new ArrayList<Object>();
            for (Object value : this.getValue((Object)entity).values()) {
                for (Property property : this.getEmbeddedProperties()) {
                    entities.addAll(property.findReferencedEntities(value));
                }
            }
            valueEntities = entities;
        }
        if (keyEntities.isEmpty()) {
            return valueEntities;
        }
        if (valueEntities.isEmpty()) {
            return keyEntities;
        }
        entities = new ArrayList(keyEntities.size() + valueEntities.size());
        entities.addAll(keyEntities);
        entities.addAll(valueEntities);
        return entities;
    }

    @Override
    public List<EntityStatement> generatePendingStatements(E entity, Object writtenEntity, Object ... arguments) {
        String sourceId = EntityConverter.getEntityReference(entity, this.getMappedId(), this.getContext(), false);
        EntityStatement statement = this.createDirectPropertyStatement(entity, (String)arguments[0], sourceId, writtenEntity);
        return statement == null ? Collections.emptyList() : Collections.singletonList(statement);
    }

    @Override
    public Map<K, T> getValue(E entity) {
        Map value = (Map)super.getValue(entity);
        return value == null ? Collections.EMPTY_MAP : value;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    public EntityClass<K> getKeyEntityClass() {
        return this.keyEntityClass;
    }

    public ValueConverter<K> getKeyConverter() {
        return this.keyConverter;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public EntityClass<T> getValueEntityClass() {
        return this.valueEntityClass;
    }

    public ValueConverter<T> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getIdColumn() {
        return this.idColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    @Override
    public String getValueColumn() {
        return this.valueColumn;
    }
}

