/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapsId;
import org.fastnate.generator.context.AccessStyle;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.CollectionProperty;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.EntityProperty;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.MapProperty;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.statements.InsertStatement;

public abstract class PluralProperty<E, C, T>
extends Property<E, C> {
    private final GeneratorContext context;
    private List<SingularProperty<T, ?>> embeddedProperties;
    private final String mappedId;

    protected static String buildIdColumn(AttributeAccessor attribute, AssociationOverride override, CollectionTable collectionMetadata, String defaultIdColumn) {
        return PluralProperty.buildIdColumn(attribute, override, collectionMetadata != null ? collectionMetadata.joinColumns() : null, defaultIdColumn);
    }

    private static String buildIdColumn(AttributeAccessor attribute, AssociationOverride override, JoinColumn[] joinColumns, String defaultIdColumn) {
        JoinColumn joinColumn;
        if (override != null && override.joinColumns().length > 0 && (joinColumn = override.joinColumns()[0]).name().length() > 0) {
            return joinColumn.name();
        }
        joinColumn = attribute.getAnnotation(JoinColumn.class);
        if (joinColumn != null && joinColumn.name().length() > 0) {
            return joinColumn.name();
        }
        if (joinColumns != null && joinColumns.length > 0 && joinColumns[0].name().length() > 0) {
            return joinColumns[0].name();
        }
        return defaultIdColumn;
    }

    protected static String buildIdColumn(AttributeAccessor attribute, AssociationOverride override, JoinTable joinTable, CollectionTable tableMetadata, String defaultIdColumn) {
        return PluralProperty.buildIdColumn(attribute, override, (JoinColumn[])(joinTable != null ? joinTable.joinColumns() : (tableMetadata != null ? tableMetadata.joinColumns() : null)), defaultIdColumn);
    }

    protected static String buildTableName(AttributeAccessor attribute, AssociationOverride override, JoinTable joinTable, CollectionTable collectionTable, String defaultTableName) {
        JoinTable joinTableOverride;
        if (override != null && (joinTableOverride = override.joinTable()) != null && joinTableOverride.name().length() > 0) {
            return joinTableOverride.name();
        }
        if (joinTable != null && joinTable.name().length() > 0) {
            return joinTable.name();
        }
        if (collectionTable != null && collectionTable.name().length() > 0) {
            return collectionTable.name();
        }
        return defaultTableName;
    }

    protected static String buildTableName(CollectionTable tableMetadata, String defaultTableName) {
        return tableMetadata != null && tableMetadata.name().length() != 0 ? tableMetadata.name() : defaultTableName;
    }

    protected static String buildValueColumn(AttributeAccessor attribute, String defaultValueColumn) {
        JoinTable tableMetadata = attribute.getAnnotation(JoinTable.class);
        if (tableMetadata != null && tableMetadata.inverseJoinColumns().length > 0 && tableMetadata.inverseJoinColumns()[0].name().length() > 0) {
            return tableMetadata.inverseJoinColumns()[0].name();
        }
        Column columnMetadata = attribute.getAnnotation(Column.class);
        if (columnMetadata != null && columnMetadata.name().length() > 0) {
            return columnMetadata.name();
        }
        return defaultValueColumn;
    }

    protected static <T> Class<T> getPropertyArgument(AttributeAccessor attribute, Class<T> explicitClass, int argumentIndex) {
        if (explicitClass != Void.TYPE) {
            return explicitClass;
        }
        if (!(attribute.getGenericType() instanceof ParameterizedType)) {
            throw new ModelException(attribute + " is not of generic type and has no defined entity class");
        }
        ParameterizedType type = (ParameterizedType)attribute.getGenericType();
        Type[] parameterArgTypes = type.getActualTypeArguments();
        if (parameterArgTypes.length > argumentIndex) {
            Type genericType = parameterArgTypes[argumentIndex];
            if (genericType instanceof ParameterizedType) {
                genericType = ((ParameterizedType)genericType).getRawType();
            }
            if (genericType instanceof Class) {
                return (Class)genericType;
            }
        }
        throw new ModelException(attribute + " has illegal generic type signature");
    }

    public PluralProperty(GeneratorContext context, AttributeAccessor attribute) {
        super(attribute);
        this.context = context;
        MapsId mapsId = attribute.getAnnotation(MapsId.class);
        this.mappedId = mapsId == null || mapsId.value().length() == 0 ? null : mapsId.value();
    }

    @Override
    public void addInsertExpression(E entity, InsertStatement statement) {
    }

    protected void buildEmbeddedProperties(Class<?> targetType) {
        if (targetType.isAnnotationPresent(Embeddable.class)) {
            Access accessType = targetType.getAnnotation(Access.class);
            AccessStyle accessStyle = accessType != null ? AccessStyle.getStyle(accessType.value()) : this.getAttribute().getAccessStyle();
            this.embeddedProperties = new ArrayList();
            Map<String, AttributeOverride> attributeOverrides = EntityClass.getAttributeOverrides(this.getAttribute().getElement());
            Map<String, AssociationOverride> accociationOverrides = EntityClass.getAccociationOverrides(this.getAttribute().getElement());
            Iterator<AttributeAccessor> iterator = accessStyle.getDeclaredAttributes(targetType).iterator();
            while (iterator.hasNext()) {
                AssociationOverride assocOverride;
                AttributeAccessor attribute;
                AttributeOverride attributeOveride = attributeOverrides.get((attribute = iterator.next()).getName());
                Column columnMetadata = attributeOveride != null ? attributeOveride.column() : attribute.getAnnotation(Column.class);
                SingularProperty<T, ?> property = this.buildProperty(attribute, columnMetadata, assocOverride = accociationOverrides.get(attribute.getName()));
                if (property == null) continue;
                this.embeddedProperties.add(property);
            }
        }
    }

    private SingularProperty<T, ?> buildProperty(AttributeAccessor attribute, Column columnMetadata, AssociationOverride override) {
        if (attribute.isPersistent()) {
            if (CollectionProperty.isCollectionProperty(attribute) || MapProperty.isMapProperty(attribute)) {
                throw new ModelException("Plural attributes not allowed for embedded element collection: " + attribute);
            }
            if (EntityProperty.isEntityProperty(attribute)) {
                return new EntityProperty(this.context, attribute, override);
            }
            return new PrimitiveProperty(this.context, this.getTable(), attribute, columnMetadata);
        }
        return null;
    }

    public abstract String getIdColumn();

    public abstract String getTable();

    public abstract String getValueColumn();

    public boolean isEmbedded() {
        return this.embeddedProperties != null;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isTableColumn() {
        return false;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public List<SingularProperty<T, ?>> getEmbeddedProperties() {
        return this.embeddedProperties;
    }

    public String getMappedId() {
        return this.mappedId;
    }
}

