/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.ClassUtils;
import org.fastnate.generator.DefaultValue;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.converter.BooleanConverter;
import org.fastnate.generator.converter.CalendarConverter;
import org.fastnate.generator.converter.CharConverter;
import org.fastnate.generator.converter.DateConverter;
import org.fastnate.generator.converter.EnumConverter;
import org.fastnate.generator.converter.LobConverter;
import org.fastnate.generator.converter.NumberConverter;
import org.fastnate.generator.converter.SerializableConverter;
import org.fastnate.generator.converter.StringConverter;
import org.fastnate.generator.converter.UnsupportedTypeConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.InsertStatement;

public class PrimitiveProperty<E, T>
extends SingularProperty<E, T> {
    private final GeneratorContext context;
    private final String table;
    private final String column;
    private final boolean required;
    private final ValueConverter<T> converter;
    private final String defaultValue;

    public static <T, E extends Enum<E>> ValueConverter<T> createConverter(AttributeAccessor attribute, Class<T> targetType, boolean mapKey) {
        if (attribute.isAnnotationPresent(Lob.class)) {
            return new LobConverter();
        }
        if (String.class == targetType) {
            return new StringConverter(attribute, mapKey);
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return new DateConverter(attribute, mapKey);
        }
        if (Calendar.class.isAssignableFrom(targetType)) {
            return new CalendarConverter(attribute, mapKey);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            return new EnumConverter<T>(attribute, targetType, mapKey);
        }
        Class type = ClassUtils.primitiveToWrapper(targetType);
        if (Character.class == type) {
            return new CharConverter();
        }
        if (Boolean.class == type) {
            return new BooleanConverter();
        }
        if (Number.class.isAssignableFrom(type)) {
            return new NumberConverter();
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return new SerializableConverter();
        }
        return new UnsupportedTypeConverter(attribute);
    }

    private static boolean isRequired(AttributeAccessor attribute) {
        Basic basic = attribute.getAnnotation(Basic.class);
        return basic != null && !basic.optional() || attribute.isAnnotationPresent(NotNull.class) || attribute.getType().isPrimitive();
    }

    public PrimitiveProperty(GeneratorContext context, String table, AttributeAccessor attribute, Column columnMetadata) {
        super(attribute);
        this.context = context;
        this.table = table;
        this.column = columnMetadata == null || columnMetadata.name().length() == 0 ? attribute.getName() : columnMetadata.name();
        this.required = columnMetadata != null && !columnMetadata.nullable() || PrimitiveProperty.isRequired(attribute);
        this.converter = PrimitiveProperty.createConverter(attribute, attribute.getType(), false);
        this.defaultValue = this.getDefaultValue(attribute);
    }

    @Override
    public void addInsertExpression(E entity, InsertStatement statement) {
        Object value = this.getValue(entity);
        if (value != null) {
            statement.addValue(this.getColumn(), this.converter.getExpression(value, this.context));
        } else if (this.defaultValue != null) {
            statement.addValue(this.getColumn(), this.converter.getExpression(this.defaultValue, this.context));
        } else {
            this.failIfRequired();
            if (this.context.isWriteNullValues()) {
                statement.addValue(this.column, "null");
            }
        }
    }

    protected String getDefaultValue(AttributeAccessor attribute) {
        DefaultValue defaultValueAnnotation = attribute.getAnnotation(DefaultValue.class);
        if (defaultValueAnnotation != null) {
            return defaultValueAnnotation.value();
        }
        return null;
    }

    protected GeneratorDialect getDialect() {
        return this.getContext().getDialect();
    }

    @Override
    public String getExpression(E entity, boolean whereExpression) {
        Object value = this.getValue(entity);
        if (value == null) {
            if (this.defaultValue != null) {
                return this.converter.getExpression(this.defaultValue, this.context);
            }
            return "null";
        }
        return this.converter.getExpression(value, this.context);
    }

    @Override
    public String getPredicate(E entity) {
        Object value = this.getValue(entity);
        if (value == null) {
            return this.column + " IS NULL";
        }
        return this.column + " = " + this.converter.getExpression(value, this.context);
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public String getTable() {
        return this.table;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public ValueConverter<T> getConverter() {
        return this.converter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

