/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;

public abstract class Property<E, T> {
    private final AttributeAccessor attribute;

    protected Property(AttributeAccessor attribute) {
        this.attribute = attribute;
    }

    public void addInsertExpression(E entity, InsertStatement statement) {
    }

    public List<EntityStatement> createPostInsertStatements(E entity) {
        return Collections.emptyList();
    }

    public List<? extends EntityStatement> createPreInsertStatements(E entity) {
        return Collections.emptyList();
    }

    protected void failIfRequired() {
        if (this.isRequired()) {
            throw new IllegalArgumentException("Required property " + this + " was not set.");
        }
    }

    public Collection<?> findReferencedEntities(E entity) {
        return Collections.emptySet();
    }

    public List<EntityStatement> generatePendingStatements(E entity, Object writtenEntity, Object ... arguments) {
        return Collections.emptyList();
    }

    public String getExpression(E entity, boolean whereExpression) {
        return null;
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getPredicate(E entity) {
        return null;
    }

    public T getValue(E entity) {
        return this.attribute.getValue(entity);
    }

    public boolean isRequired() {
        return false;
    }

    public abstract boolean isTableColumn();

    protected void setValue(E entity, T value) {
        this.attribute.setValue(entity, value);
    }

    public String toString() {
        return this.attribute.getName();
    }

    public AttributeAccessor getAttribute() {
        return this.attribute;
    }
}

