/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.util.Collections;
import java.util.List;
import javax.persistence.SequenceGenerator;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;
import org.fastnate.generator.statements.PlainStatement;

public class SequenceIdGenerator
extends IdGenerator {
    private final GeneratorDialect dialect;
    private final String sequenceName;
    private final boolean relativeIds;
    private final int allocationSize;
    private long initialValue;
    private long nextValue;
    private long currentSequenceValue;

    public SequenceIdGenerator(SequenceGenerator generator, GeneratorDialect dialect, boolean relativeIds) {
        this.dialect = dialect;
        this.relativeIds = relativeIds;
        this.allocationSize = generator.allocationSize();
        this.nextValue = this.initialValue = (long)generator.initialValue();
        this.currentSequenceValue = this.initialValue - 1L;
        this.sequenceName = generator.sequenceName();
    }

    @Override
    public void addNextValue(InsertStatement statement, String column, Number value) {
        String expression;
        if (this.dialect.isNextSequenceValueInInsertSupported() && this.currentSequenceValue <= value.longValue()) {
            this.currentSequenceValue = this.currentSequenceValue < this.initialValue ? this.initialValue : (this.currentSequenceValue += (long)this.allocationSize);
            expression = this.dialect.buildNextSequenceValue(this.sequenceName, this.allocationSize);
        } else {
            expression = this.dialect.buildCurrentSequenceValue(this.sequenceName, this.allocationSize);
        }
        long diff = this.currentSequenceValue - value.longValue();
        if (diff != 0L) {
            expression = '(' + expression + " - " + diff + ')';
        }
        statement.addValue(column, expression);
    }

    @Override
    public List<? extends EntityStatement> alignNextValue() {
        if (!(this.relativeIds || this.nextValue <= this.initialValue || this.currentSequenceValue < this.nextValue && this.currentSequenceValue >= this.initialValue)) {
            long currentValue = this.currentSequenceValue;
            this.currentSequenceValue = this.nextValue - 1L;
            return this.dialect.adjustNextSequenceValue(this.sequenceName, currentValue, this.currentSequenceValue + (long)this.allocationSize, this.allocationSize);
        }
        return Collections.emptyList();
    }

    @Override
    public long createNextValue() {
        return this.nextValue++;
    }

    @Override
    public List<? extends EntityStatement> createPreInsertStatements() {
        if (!this.dialect.isNextSequenceValueInInsertSupported() && this.currentSequenceValue <= this.nextValue) {
            this.currentSequenceValue = this.currentSequenceValue < this.initialValue ? this.initialValue : (this.currentSequenceValue += (long)this.allocationSize);
            return Collections.singletonList(new PlainStatement(this.dialect.buildNextSequenceValue(this.sequenceName, this.allocationSize)));
        }
        return Collections.emptyList();
    }

    @Override
    public long getCurrentValue() {
        return this.nextValue - 1L;
    }

    @Override
    public String getExpression(String table, String column, Number targetId, boolean whereExpression) {
        if (!whereExpression || this.dialect.isSequenceInWhereSupported()) {
            String reference = this.dialect.buildCurrentSequenceValue(this.sequenceName, this.allocationSize);
            long diff = this.currentSequenceValue - targetId.longValue();
            if (diff == 0L) {
                return reference;
            }
            return "(" + reference + " - " + diff + ")";
        }
        long diff = this.nextValue - 1L - targetId.longValue();
        return "(SELECT max(" + column + ')' + (diff == 0L ? "" : " - " + diff) + " FROM " + table + ')';
    }

    @Override
    public boolean isPostIncrement() {
        return false;
    }

    @Override
    public void setCurrentValue(long currentValue) {
        this.nextValue = this.initialValue = currentValue + 1L;
        this.currentSequenceValue = currentValue;
    }
}

