/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.TableGenerator;
import org.apache.commons.lang.StringUtils;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.provider.JpaProvider;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.InsertStatement;
import org.fastnate.generator.statements.PlainStatement;
import org.fastnate.generator.statements.TableStatement;
import org.fastnate.generator.statements.UpdateStatement;

public class TableIdGenerator
extends IdGenerator {
    private final GeneratorDialect dialect;
    private final boolean relativeIds;
    private final String generatorTable;
    private final String pkColumnName;
    private final String pkColumnValue;
    private final String valueColumnName;
    private final int allocationSize;
    private long initialValue;
    private long nextValue;
    private long maxAllocatedValue;

    public TableIdGenerator(TableGenerator generator, GeneratorDialect dialect, JpaProvider provider, boolean relativeIds) {
        this.dialect = dialect;
        this.relativeIds = relativeIds;
        this.allocationSize = generator.allocationSize();
        ModelException.test(this.allocationSize > 0, "Only allocation sizes greater 0 are allowed, found {}", this.allocationSize);
        this.nextValue = this.initialValue = (long)generator.initialValue();
        this.maxAllocatedValue = this.initialValue - 1L;
        this.generatorTable = StringUtils.defaultIfEmpty((String)generator.table(), (String)provider.getDefaultGeneratorTable());
        this.valueColumnName = StringUtils.defaultIfEmpty((String)generator.valueColumnName(), (String)provider.getDefaultGeneratorTableValueColumnName());
        this.pkColumnName = StringUtils.defaultIfEmpty((String)generator.pkColumnName(), (String)provider.getDefaultGeneratorTablePkColumnName());
        String value = StringUtils.defaultIfEmpty((String)generator.pkColumnValue(), (String)provider.getDefaultGeneratorTablePkColumnValue());
        this.pkColumnValue = StringUtils.isEmpty((String)value) ? null : dialect.quoteString(value);
    }

    @Override
    public void addNextValue(InsertStatement statement, String column, Number value) {
        statement.addValue(column, "(SELECT " + this.valueColumnName + " - " + (this.getValueColumnValue() - value.longValue()) + " FROM " + this.generatorTable + " WHERE " + this.pkColumnName + " = " + this.pkColumnValue + ')');
    }

    @Override
    public List<? extends EntityStatement> alignNextValue() {
        if (this.relativeIds) {
            if (this.maxAllocatedValue >= this.nextValue) {
                UpdateStatement statement = new UpdateStatement(this.generatorTable, this.pkColumnName, this.pkColumnValue);
                statement.addValue(this.valueColumnName, this.valueColumnName + " - " + (this.maxAllocatedValue - (this.nextValue - 1L)));
                this.maxAllocatedValue = this.nextValue - 1L;
                return Collections.singletonList(statement);
            }
        } else if (this.maxAllocatedValue < this.initialValue) {
            if (this.nextValue > this.initialValue) {
                this.maxAllocatedValue = this.nextValue;
                InsertStatement statement = new InsertStatement(this.generatorTable);
                statement.addValue(this.pkColumnName, this.pkColumnValue);
                statement.addValue(this.valueColumnName, String.valueOf(this.maxAllocatedValue + (long)this.allocationSize - 1L));
                return Collections.singletonList(statement);
            }
        } else if (this.maxAllocatedValue >= this.nextValue) {
            UpdateStatement statement = new UpdateStatement(this.generatorTable, this.pkColumnName, this.pkColumnValue);
            this.maxAllocatedValue = this.nextValue;
            statement.addValue(this.valueColumnName, String.valueOf(this.maxAllocatedValue + (long)this.allocationSize - 1L));
            return Collections.singletonList(statement);
        }
        return Collections.emptyList();
    }

    @Override
    public long createNextValue() {
        return this.nextValue++;
    }

    @Override
    public List<? extends EntityStatement> createPreInsertStatements() {
        TableStatement statement;
        if (this.maxAllocatedValue >= this.nextValue) {
            return Collections.emptyList();
        }
        boolean firstUpdate = this.maxAllocatedValue < this.initialValue;
        this.maxAllocatedValue += (long)this.allocationSize;
        if (this.relativeIds) {
            ArrayList<EntityStatement> result = new ArrayList<EntityStatement>(2);
            if (firstUpdate) {
                result.add(new PlainStatement("INSERT INTO " + this.generatorTable + " (" + this.pkColumnName + ", " + this.valueColumnName + ") SELECT " + this.pkColumnValue + ", " + this.maxAllocatedValue + ' ' + this.dialect.getOptionalTable() + " WHERE NOT EXISTS (SELECT * FROM " + this.generatorTable + " WHERE " + this.pkColumnName + " = " + this.pkColumnValue + ')'));
            }
            UpdateStatement statement2 = new UpdateStatement(this.generatorTable, this.pkColumnName, this.pkColumnValue);
            statement2.addValue(this.valueColumnName, this.valueColumnName + " + " + this.allocationSize);
            result.add(statement2);
            return result;
        }
        if (firstUpdate) {
            statement = new InsertStatement(this.generatorTable);
            statement.addValue(this.pkColumnName, this.pkColumnValue);
        } else {
            statement = new UpdateStatement(this.generatorTable, this.pkColumnName, this.pkColumnValue);
        }
        statement.addValue(this.valueColumnName, String.valueOf(this.maxAllocatedValue + (long)this.allocationSize));
        return Collections.singletonList(statement);
    }

    @Override
    public IdGenerator derive(String currentTable) {
        if (StringUtils.isEmpty((String)this.pkColumnValue)) {
            return new TableIdGenerator(this.dialect, this.relativeIds, this.generatorTable, this.pkColumnName, this.dialect.quoteString(currentTable), this.valueColumnName, this.allocationSize, this.initialValue, this.nextValue, this.maxAllocatedValue);
        }
        return this;
    }

    @Override
    public long getCurrentValue() {
        return this.nextValue - 1L;
    }

    @Override
    public String getExpression(String tableName, String columnName, Number targetId, boolean whereExpression) {
        long diff = this.getValueColumnValue() - targetId.longValue();
        return "(SELECT " + this.valueColumnName + (diff == 0L ? "" : " - " + diff) + " FROM " + this.generatorTable + " WHERE " + this.pkColumnName + " = " + this.pkColumnValue + ')';
    }

    private long getValueColumnValue() {
        return this.maxAllocatedValue + (long)this.allocationSize;
    }

    @Override
    public boolean isPostIncrement() {
        return false;
    }

    @Override
    public void setCurrentValue(long currentValue) {
        this.nextValue = currentValue + 1L;
        this.maxAllocatedValue = currentValue;
    }

    public GeneratorDialect getDialect() {
        return this.dialect;
    }

    public boolean isRelativeIds() {
        return this.relativeIds;
    }

    public String getGeneratorTable() {
        return this.generatorTable;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public int getAllocationSize() {
        return this.allocationSize;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public long getNextValue() {
        return this.nextValue;
    }

    public long getMaxAllocatedValue() {
        return this.maxAllocatedValue;
    }

    private TableIdGenerator(GeneratorDialect dialect, boolean relativeIds, String generatorTable, String pkColumnName, String pkColumnValue, String valueColumnName, int allocationSize, long initialValue, long nextValue, long maxAllocatedValue) {
        this.dialect = dialect;
        this.relativeIds = relativeIds;
        this.generatorTable = generatorTable;
        this.pkColumnName = pkColumnName;
        this.pkColumnValue = pkColumnValue;
        this.valueColumnName = valueColumnName;
        this.allocationSize = allocationSize;
        this.initialValue = initialValue;
        this.nextValue = nextValue;
        this.maxAllocatedValue = maxAllocatedValue;
    }
}

