/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.AbstractValueConverter;

public class SerializableConverter
extends AbstractValueConverter<Serializable> {
    private static final int DEFAULT_BUFFER_SIZE = 512;

    @Override
    public String getExpression(Serializable value, GeneratorContext context) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
            try (ObjectOutputStream stream = new ObjectOutputStream(buffer);){
                stream.writeObject(value);
            }
            return context.getDialect().createBlobExpression(buffer.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

