/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.beans.ConstructorProperties;
import java.util.Date;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.AbstractValueConverter;

public abstract class TemporalConverter<T>
extends AbstractValueConverter<T> {
    private final TemporalType type;

    public TemporalConverter(AttributeAccessor attribute, boolean mapKey) {
        TemporalType temporalType = TemporalType.TIMESTAMP;
        if (mapKey) {
            MapKeyTemporal temporal = attribute.getAnnotation(MapKeyTemporal.class);
            if (temporal != null) {
                temporalType = temporal.value();
            }
        } else {
            Temporal temporal = attribute.getAnnotation(Temporal.class);
            if (temporal != null) {
                temporalType = temporal.value();
            }
        }
        this.type = temporalType;
    }

    @Override
    public String getExpression(Date value, GeneratorContext context) {
        return context.getDialect().convertTemporalValue(value, this.type);
    }

    @ConstructorProperties(value={"type"})
    public TemporalConverter(TemporalType type) {
        this.type = type;
    }
}

